/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.server.command;

import cc.lvjia.wings.server.apparatus.FlightApparatus;
import cc.lvjia.wings.server.command.WingsArgument;
import cc.lvjia.wings.server.item.BatBloodBottleItem;
import cc.lvjia.wings.server.item.WingsBottleItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class WingsCommand {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.wings.give.failed"));
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.wings.take.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wings").requires(cs -> cs.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"give").then(Commands.argument((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::giveWingSelf))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::giveWing))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"take").executes(WingsCommand::takeWingsSelf)).then(Commands.argument((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::takeSpecificWingsSelf))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(WingsCommand::takeWings)).then(Commands.argument((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::takeSpecificWings)))));
    }

    private static Collection<ServerPlayer> getSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return List.of(((CommandSourceStack)ctx.getSource()).getPlayerOrException());
    }

    private static int giveWingSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WingsCommand.executeGiveWing(ctx, WingsCommand.getSelf(ctx), WingsArgument.getWings(ctx, "wings"));
    }

    private static int giveWing(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WingsCommand.executeGiveWing(ctx, EntityArgument.getPlayers(ctx, (String)"targets"), WingsArgument.getWings(ctx, "wings"));
    }

    private static int executeGiveWing(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets, FlightApparatus wings) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!WingsBottleItem.giveWing(player, wings)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.give.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.give.success.multiple", (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeWingsSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WingsCommand.executeTakeWings(ctx, WingsCommand.getSelf(ctx));
    }

    private static int takeWings(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WingsCommand.executeTakeWings(ctx, EntityArgument.getPlayers(ctx, (String)"targets"));
    }

    private static int executeTakeWings(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!BatBloodBottleItem.removeWings((Player)player)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.multiple", (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeSpecificWingsSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WingsCommand.executeTakeSpecificWings(ctx, WingsCommand.getSelf(ctx), WingsArgument.getWings(ctx, "wings"));
    }

    private static int takeSpecificWings(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return WingsCommand.executeTakeSpecificWings(ctx, EntityArgument.getPlayers(ctx, (String)"targets"), WingsArgument.getWings(ctx, "wings"));
    }

    private static int executeTakeSpecificWings(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> targets, FlightApparatus wings) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!BatBloodBottleItem.removeWings(player, wings)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.multiple", (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }
}

