/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.server.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VeinSettings {
    private static final Logger LOGGER = LogManager.getLogger((String)"WingsConfig");
    private static final int MIN_SIZE = 8;
    private static final int MAX_SIZE = 32;
    private static final int MIN_COUNT = 0;
    private static final int MAX_COUNT = 128;
    private static final int MIN_WORLD_HEIGHT = -64;
    private static final int MAX_WORLD_HEIGHT = 320;
    private final String name;
    private final ModConfigSpec.IntValue size;
    private final ModConfigSpec.IntValue count;
    private final ModConfigSpec.IntValue minHeight;
    private final ModConfigSpec.IntValue maxHeight;
    private final int defaultSize;
    private final int defaultCount;
    private final int defaultMinHeight;
    private final int defaultMaxHeight;

    VeinSettings(String name, ModConfigSpec.Builder builder, int defaultSize, int defaultCount, int defaultMaxHeight) {
        this.name = name;
        this.defaultSize = defaultSize;
        this.defaultCount = defaultCount;
        this.defaultMinHeight = 0;
        this.defaultMaxHeight = defaultMaxHeight;
        builder.push(name);
        this.size = builder.comment("Vein size for ore '" + name + "'").defineInRange("size", defaultSize, 8, 32);
        this.count = builder.comment("Number of ore veins per chunk for '" + name + "'").defineInRange("count", defaultCount, 0, 128);
        this.minHeight = builder.comment("Minimum generation height for '" + name + "'").defineInRange("minHeight", 0, -64, 320);
        this.maxHeight = builder.comment("Maximum generation height for '" + name + "'").defineInRange("maxHeight", defaultMaxHeight, -64, 320);
        builder.pop();
    }

    public void getSize() {
        this.readInt(this.size, "size", 8, 32, this.defaultSize);
    }

    public void getCount() {
        this.readInt(this.count, "count", 0, 128, this.defaultCount);
    }

    public int getMinHeight() {
        return this.readInt(this.minHeight, "minHeight", -64, 320, this.defaultMinHeight);
    }

    public void getMaxHeight() {
        int min = this.getMinHeight();
        int max = this.readInt(this.maxHeight, "maxHeight", -64, 320, this.defaultMaxHeight);
        if (max < min) {
            LOGGER.warn("Max height {} is below min height {} for ore '{}'. Reverting to {}.", (Object)max, (Object)min, (Object)this.name, (Object)min);
            this.maxHeight.set((Object)min);
        }
    }

    public void validate() {
        this.getSize();
        this.getCount();
        this.getMinHeight();
        this.getMaxHeight();
    }

    private int readInt(ModConfigSpec.IntValue value, String propertyName, int min, int max, int fallback) {
        if (value == null) {
            LOGGER.warn("Ore '{}' property '{}' is null. Reverting to default {}.", (Object)this.name, (Object)propertyName, (Object)fallback);
            return fallback;
        }
        int current = (Integer)value.get();
        if (current < min || current > max) {
            LOGGER.warn("Ore '{}' property '{}' out of range: {} (expected {}-{}). Reverting to default {}.", (Object)this.name, (Object)propertyName, (Object)current, (Object)min, (Object)max, (Object)fallback);
            value.set((Object)fallback);
            return fallback;
        }
        return current;
    }
}

