/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.server.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WingsConfig {
    public static final ModConfigSpec SPEC;
    private static final Logger LOGGER;
    private static final List<String> DEFAULT_WEAR_OBSTRUCTIONS;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> WEAR_OBSTRUCTIONS;

    private WingsConfig() {
    }

    public static List<String> getWearObstructions() {
        List entries = (List)WEAR_OBSTRUCTIONS.get();
        if (entries == null) {
            LOGGER.warn("Wear obstructions list is null. Reverting to defaults {}.", DEFAULT_WEAR_OBSTRUCTIONS);
            WEAR_OBSTRUCTIONS.set(DEFAULT_WEAR_OBSTRUCTIONS);
            return Collections.unmodifiableList(new ArrayList<String>(DEFAULT_WEAR_OBSTRUCTIONS));
        }
        ArrayList<String> sanitized = new ArrayList<String>();
        for (Object entryObj : entries) {
            String entry;
            if (entryObj == null || (entry = entryObj.toString().trim()).isEmpty()) continue;
            if (ResourceLocation.tryParse((String)entry) == null) {
                LOGGER.warn("Ignoring invalid wear obstruction id '{}'. Expected a namespaced id such as 'minecraft:elytra'.", (Object)entry);
                continue;
            }
            sanitized.add(entry);
        }
        if (sanitized.isEmpty()) {
            LOGGER.warn("No valid wear obstruction entries found. Reverting to defaults {}.", DEFAULT_WEAR_OBSTRUCTIONS);
            WEAR_OBSTRUCTIONS.set(DEFAULT_WEAR_OBSTRUCTIONS);
            sanitized.addAll(DEFAULT_WEAR_OBSTRUCTIONS);
        }
        return Collections.unmodifiableList(sanitized);
    }

    public static String[] getWearObstructionsArray() {
        return (String[])WingsConfig.getWearObstructions().toArray(String[]::new);
    }

    public static void validate() {
        WingsConfig.getWearObstructions();
    }

    static {
        LOGGER = LogManager.getLogger((String)"WingsConfig");
        DEFAULT_WEAR_OBSTRUCTIONS = List.of("minecraft:elytra");
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("General configuration for lv wings").push("general");
        WEAR_OBSTRUCTIONS = builder.comment("List of item IDs that prevent players from equipping wings.").defineListAllowEmpty("wearObstructions", DEFAULT_WEAR_OBSTRUCTIONS, () -> "", value -> value instanceof String && ResourceLocation.tryParse((String)((String)value)) != null);
        builder.pop();
        SPEC = builder.build();
    }
}

