/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.server.flight;

import cc.lvjia.wings.server.apparatus.FlightApparatus;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface Flight {
    default public void setIsFlying(boolean isFlying) {
        this.setIsFlying(isFlying, PlayerSet.empty());
    }

    public void setIsFlying(boolean var1, PlayerSet var2);

    public boolean isFlying();

    default public void toggleIsFlying(PlayerSet players) {
        this.setIsFlying(!this.isFlying(), players);
    }

    public int getTimeFlying();

    public void setTimeFlying(int var1);

    public void setWing(FlightApparatus var1, PlayerSet var2);

    public FlightApparatus getWing();

    default public void setWing(FlightApparatus wing) {
        this.setWing(wing, PlayerSet.empty());
    }

    public float getFlyingAmount(float var1);

    public void registerFlyingListener(FlyingListener var1);

    public void registerSyncListener(SyncListener var1);

    public boolean canFly(Player var1);

    public boolean hasEffect(Player var1);

    public boolean canLand(Player var1);

    public void tick(Player var1);

    public void onFlown(Player var1, Vec3 var2);

    public void clone(Flight var1);

    public void sync(PlayerSet var1);

    public void serialize(FriendlyByteBuf var1);

    public void deserialize(FriendlyByteBuf var1);

    public static interface PlayerSet {
        public static PlayerSet empty() {
            return n -> {};
        }

        public static PlayerSet ofSelf() {
            return Notifier::notifySelf;
        }

        public static PlayerSet ofPlayer(ServerPlayer player) {
            return n -> n.notifyPlayer(player);
        }

        public static PlayerSet ofOthers() {
            return Notifier::notifyOthers;
        }

        public static PlayerSet ofAll() {
            return n -> {
                n.notifySelf();
                n.notifyOthers();
            };
        }

        public void notify(Notifier var1);
    }

    public static interface Notifier {
        public static Notifier of(final Runnable notifySelf, final Consumer<ServerPlayer> notifyPlayer, final Runnable notifyOthers) {
            return new Notifier(){

                @Override
                public void notifySelf() {
                    notifySelf.run();
                }

                @Override
                public void notifyPlayer(ServerPlayer player) {
                    notifyPlayer.accept(player);
                }

                @Override
                public void notifyOthers() {
                    notifyOthers.run();
                }
            };
        }

        public void notifySelf();

        public void notifyPlayer(ServerPlayer var1);

        public void notifyOthers();
    }

    public static interface SyncListener {
        public static Consumer<SyncListener> onSyncUsing(PlayerSet players) {
            return l -> l.onSync(players);
        }

        public void onSync(PlayerSet var1);
    }

    public static interface FlyingListener {
        public static Consumer<FlyingListener> onChangeUsing(boolean isFlying) {
            return l -> l.onChange(isFlying);
        }

        public void onChange(boolean var1);
    }
}

