/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.util;

import com.google.common.collect.ImmutableListMultimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

public final class KeyInputListener {
    private static final List<KeyMapping> KEY_MAPPINGS = new ArrayList<KeyMapping>();
    private static final Set<KeyMapping.Category> KEY_CATEGORIES = new LinkedHashSet<KeyMapping.Category>();
    private final ImmutableListMultimap<KeyMapping, Runnable> bindings;

    private KeyInputListener(ImmutableListMultimap<KeyMapping, Runnable> bindings) {
        this.bindings = bindings;
    }

    public static Builder builder() {
        return new BuilderRoot();
    }

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        KEY_CATEGORIES.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).registerCategory(arg_0));
        KEY_MAPPINGS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        this.bindings.asMap().entrySet().stream().filter(e -> ((KeyMapping)e.getKey()).consumeClick()).flatMap(e -> ((Collection)e.getValue()).stream()).forEach(Runnable::run);
    }

    public static final class BuilderRoot
    implements Builder {
        private final ImmutableListMultimap.Builder<KeyMapping, Runnable> bindings;

        private BuilderRoot() {
            this((ImmutableListMultimap.Builder<KeyMapping, Runnable>)ImmutableListMultimap.builder());
        }

        private BuilderRoot(ImmutableListMultimap.Builder<KeyMapping, Runnable> bindings) {
            this.bindings = bindings;
        }

        @Override
        public CategoryBuilder category(KeyMapping.Category category) {
            KEY_CATEGORIES.add(category);
            return new CategoryBuilderRoot(this, category);
        }

        @Override
        public KeyInputListener build() {
            return new KeyInputListener((ImmutableListMultimap<KeyMapping, Runnable>)this.bindings.build());
        }
    }

    public static final class BindingBuilder
    extends ChildBuilder<CategoryBuilderRoot>
    implements CategoryBuilder {
        private final KeyMapping binding;

        private BindingBuilder(CategoryBuilderRoot delegate, KeyMapping binding) {
            super(delegate);
            this.binding = binding;
        }

        public BindingBuilder onPress(Runnable runnable) {
            ((BuilderRoot)((CategoryBuilderRoot)this.parent).parent).bindings.put((Object)this.binding, (Object)runnable);
            return this;
        }

        @Override
        public BindingBuilder key(String desc, IKeyConflictContext context, KeyModifier modifier, int keyCode) {
            return ((CategoryBuilderRoot)this.parent).key(desc, context, modifier, keyCode);
        }
    }

    private static final class CategoryBuilderRoot
    extends ChildBuilder<BuilderRoot>
    implements CategoryBuilder {
        private final KeyMapping.Category category;

        private CategoryBuilderRoot(BuilderRoot delegate, KeyMapping.Category category) {
            super(delegate);
            this.category = category;
        }

        @Override
        public BindingBuilder key(String desc, IKeyConflictContext context, KeyModifier modifier, int keyCode) {
            KeyMapping binding = new KeyMapping(desc, context, modifier, InputConstants.Type.KEYSYM, keyCode, this.category);
            KEY_MAPPINGS.add(binding);
            return new BindingBuilder(this, binding);
        }
    }

    private static abstract class ChildBuilder<P extends Builder>
    implements Builder {
        final P parent;

        private ChildBuilder(P parent) {
            this.parent = parent;
        }

        @Override
        public final CategoryBuilder category(KeyMapping.Category category) {
            return this.parent.category(category);
        }

        @Override
        public final KeyInputListener build() {
            return this.parent.build();
        }
    }

    public static interface CategoryBuilder
    extends Builder {
        public BindingBuilder key(String var1, IKeyConflictContext var2, KeyModifier var3, int var4);
    }

    public static interface Builder {
        public CategoryBuilder category(KeyMapping.Category var1);

        public KeyInputListener build();
    }
}

