/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings;

import com.mojang.serialization.Lifecycle;
import com.toni.wings.Proxy;
import com.toni.wings.client.ClientProxy;
import com.toni.wings.server.ServerProxy;
import com.toni.wings.server.apparatus.BuffedFlightApparatus;
import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.apparatus.SimpleFlightApparatus;
import com.toni.wings.server.command.WingsArgument;
import com.toni.wings.server.config.WingsConfig;
import com.toni.wings.server.config.WingsItemsConfig;
import com.toni.wings.server.config.WingsOreConfig;
import com.toni.wings.server.effect.WingsEffects;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.item.WingSettings;
import com.toni.wings.server.item.WingsItems;
import com.toni.wings.server.sound.WingsSounds;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="wings")
public final class WingsMod {
    public static final String ID = "wings";
    private static WingsMod INSTANCE;
    public static final Registry<FlightApparatus> WINGS;
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;
    public static final RegistryObject<SingletonArgumentInfo<WingsArgument>> WINGS_ARGUMENT_TYPE;
    public static final FlightApparatus NONE;
    public static final FlightApparatus WINGLESS;
    public static final FlightApparatus ANGEL_WINGS;
    public static final FlightApparatus PARROT_WINGS;
    public static final FlightApparatus BAT_WINGS;
    public static final FlightApparatus BLUE_BUTTERFLY_WINGS;
    public static final FlightApparatus DRAGON_WINGS;
    public static final FlightApparatus EVIL_WINGS;
    public static final FlightApparatus FAIRY_WINGS;
    public static final FlightApparatus MONARCH_BUTTERFLY_WINGS;
    public static final FlightApparatus SLIME_WINGS;
    public static final FlightApparatus FIRE_WINGS;
    public static final FlightApparatus LVJIA_SUPER_WINGS;
    private Proxy proxy;

    public WingsMod() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Already constructed!");
        }
        INSTANCE = this;
        IEventBus bus = WingsMod.getModEventBus();
        ModLoadingContext context = WingsMod.getModLoadingContext();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WingsConfig.SPEC, "wings-common.toml");
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WingsItemsConfig.SPEC, "wings-items.toml");
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WingsOreConfig.SPEC, "wings-ores.toml");
        WingsItems.REG.register(bus);
        WingsSounds.REG.register(bus);
        WingsEffects.REG.register(bus);
        COMMAND_ARGUMENT_TYPES.register(bus);
        this.proxy = (Proxy)DistExecutor.unsafeRunForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        this.proxy.init(bus);
    }

    private static IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    private static ModLoadingContext getModLoadingContext() {
        return ModLoadingContext.get();
    }

    public void addFlightListeners(Player player, Flight instance) {
        this.requireProxy().addFlightListeners(player, instance);
    }

    public static WingsMod instance() {
        return INSTANCE;
    }

    public void invalidateFlightView(Player player) {
        this.requireProxy().invalidateFlightView(player);
    }

    private Proxy requireProxy() {
        if (this.proxy == null) {
            throw new IllegalStateException("Proxy not initialized");
        }
        return this.proxy;
    }

    public static ResourceLocation locate(String name) {
        ResourceLocation location = ResourceLocation.m_214293_((String)ID, (String)name);
        if (location == null) {
            throw new IllegalArgumentException("Invalid resource path: " + name);
        }
        return location;
    }

    static {
        WINGS = new DefaultedRegistry(Names.NONE.toString(), ResourceKey.m_135788_((ResourceLocation)WingsMod.locate(ID)), Lifecycle.experimental(), null);
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registry.f_235724_, (String)ID);
        WINGS_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register(ID, () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(WingsArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(WingsArgument::wings)));
        NONE = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.NONE, (Object)FlightApparatus.NONE);
        WINGLESS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.WINGLESS, (Object)FlightApparatus.NONE);
        ANGEL_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.ANGEL, (Object)new SimpleFlightApparatus(WingsItemsConfig.ANGEL));
        PARROT_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.PARROT, (Object)new SimpleFlightApparatus(WingsItemsConfig.PARROT));
        BAT_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.BAT, (Object)new SimpleFlightApparatus(WingsItemsConfig.BAT));
        BLUE_BUTTERFLY_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.BLUE_BUTTERFLY, (Object)new SimpleFlightApparatus(WingsItemsConfig.BLUE_BUTTERFLY));
        DRAGON_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.DRAGON, (Object)new SimpleFlightApparatus(WingsItemsConfig.DRAGON));
        EVIL_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.EVIL, (Object)new SimpleFlightApparatus(WingsItemsConfig.EVIL));
        FAIRY_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.FAIRY, (Object)new SimpleFlightApparatus(WingsItemsConfig.FAIRY));
        MONARCH_BUTTERFLY_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.MONARCH_BUTTERFLY, (Object)new SimpleFlightApparatus(WingsItemsConfig.MONARCH_BUTTERFLY));
        SLIME_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.SLIME, (Object)new SimpleFlightApparatus(WingsItemsConfig.SLIME));
        FIRE_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.FIRE, (Object)new SimpleFlightApparatus(WingsItemsConfig.FIRE));
        LVJIA_SUPER_WINGS = (FlightApparatus)Registry.m_122965_(WINGS, (ResourceLocation)Names.LVJIA_SUPER, (Object)new BuffedFlightApparatus((WingSettings)WingsItemsConfig.LVJIA_SUPER, BuffedFlightApparatus.EffectSettings.of(MobEffects.f_19606_, 2, 40, 40), BuffedFlightApparatus.EffectSettings.of(MobEffects.f_19603_, 1, 40, 40)));
    }

    public static final class Names {
        public static final ResourceLocation NONE = Names.create("none");
        public static final ResourceLocation WINGLESS = Names.create("wingless");
        public static final ResourceLocation ANGEL = Names.create("angel_wings");
        public static final ResourceLocation PARROT = Names.create("parrot_wings");
        public static final ResourceLocation SLIME = Names.create("slime_wings");
        public static final ResourceLocation BLUE_BUTTERFLY = Names.create("blue_butterfly_wings");
        public static final ResourceLocation MONARCH_BUTTERFLY = Names.create("monarch_butterfly_wings");
        public static final ResourceLocation FIRE = Names.create("fire_wings");
        public static final ResourceLocation BAT = Names.create("bat_wings");
        public static final ResourceLocation FAIRY = Names.create("fairy_wings");
        public static final ResourceLocation EVIL = Names.create("evil_wings");
        public static final ResourceLocation DRAGON = Names.create("dragon_wings");
        public static final ResourceLocation LVJIA_SUPER = Names.create("lvjia_super_wing");

        private Names() {
        }

        private static ResourceLocation create(String path) {
            ResourceLocation location = ResourceLocation.m_214293_((String)WingsMod.ID, (String)path);
            if (location == null) {
                throw new IllegalArgumentException("Invalid resource path: " + path);
            }
            return location;
        }
    }

    static class ProxyInit {
        ProxyInit() {
        }

        static Proxy createClient() {
            return new ClientProxy();
        }

        static Proxy createServer() {
            return new ServerProxy();
        }
    }
}

