/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.flight;

import com.google.common.collect.ImmutableMap;
import com.toni.wings.client.flight.Animator;
import com.toni.wings.util.MathH;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.Vec3;

public final class AnimatorAvian
implements Animator {
    private static final int LAND_TRANSITION_DURATION = 12;
    private static final int GLIDE_TRANSITION_DURATION = 60;
    private static final int IDLE_TRANSITION_DURATION = 18;
    private static final int LIFT_TRANSITION_DURATION = 20;
    private static final int FALL_TRANSITION_DURATION = 8;
    private final Movement restPosition = new RestPosition(this);
    private Movement movement = new IdleMovement();
    private float prevFlapCycle;
    private float flapCycle;

    private void beginMovement(Movement movement, int transitionDuration) {
        this.setMovement(new Transition(this.movement, movement, transitionDuration));
    }

    private void setMovement(Movement movement) {
        this.movement.onEnd();
        this.movement = movement;
    }

    private void flap(float amount) {
        this.flapCycle += amount;
    }

    private float getFlapTime(float delta) {
        return MathH.lerp(this.prevFlapCycle, this.flapCycle, delta);
    }

    @Override
    public void beginLand() {
        this.beginMovement(new LandMovement(), 12);
    }

    @Override
    public void beginGlide() {
        this.beginMovement(new GlideMovement(), 60);
    }

    @Override
    public void beginIdle() {
        this.beginMovement(new IdleMovement(), 18);
    }

    @Override
    public void beginLift() {
        this.beginMovement(new LiftMovement(), 20);
    }

    @Override
    public void beginFall() {
        this.beginMovement(new FallMovement(this), 8);
    }

    public Vec3 getWingRotation(int index, float delta) {
        return this.movement.getWingRotation(index, delta);
    }

    public Vec3 getFeatherRotation(int index, float delta) {
        return this.movement.getFeatherRotation(index, delta);
    }

    @Override
    public void update() {
        this.prevFlapCycle = this.flapCycle;
        this.flap(this.movement.update());
    }

    private float getWeight(int index) {
        return (float)Math.min(Math.abs(index - 1), 2) / 2.0f;
    }

    private final class RestPosition
    implements Movement {
        private final WingPose wing = WingPose.builder().with(0, 0.0, -23.5, -16.0).with(1, 0.0, 13.0, 29.0).with(2, 0.0, 12.0, -28.0).with(3, 0.0, 4.0, 18.3).build();
        private final WingPose feather = WingPose.builder().with(0, 0.0, 0.0, 23.48).build();

        private RestPosition(AnimatorAvian animatorAvian) {
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            return this.wing.get(index);
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            return this.feather.get(index);
        }

        @Override
        public float update() {
            return 0.0f;
        }
    }

    private static interface Movement {
        public Vec3 getWingRotation(int var1, float var2);

        public Vec3 getFeatherRotation(int var1, float var2);

        public float update();

        default public void onEnd() {
        }
    }

    private final class IdleMovement
    implements Movement {
        private final WingPose wing = WingPose.builder().with(0, 40.0, -60.0, -50.0).with(1, 72.0, 10.0, 100.0).with(2, 0.0, -10.0, -120.0).with(3, 10.0, 0.0, 100.0).build();
        private final WingPose feather = WingPose.builder().with(0, 10.0, 20.0, 23.48).with(1, 0.0, 20.0, -70.0).with(2, 0.0, 10.0, 40.0).with(3, -20.0, 0.0, 20.0).build();

        private IdleMovement() {
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            float pos = AnimatorAvian.this.getWeight(index);
            float time = AnimatorAvian.this.getFlapTime(delta);
            return this.wing.get(index).add(0.0, Math.sin(time) * 3.0 * (double)pos, 0.0);
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            float pos = AnimatorAvian.this.getWeight(index);
            float time = AnimatorAvian.this.getFlapTime(delta);
            return this.feather.get(index).add(0.0, -Math.sin(time) * 5.0 * (double)pos, 0.0);
        }

        @Override
        public float update() {
            return 0.035f;
        }
    }

    private final class Transition
    implements Movement {
        private final Movement start;
        private final Movement end;
        private final int duration;
        private int lastTime;
        private int time;
        private boolean isActive = true;

        private Transition(Movement start, Movement end, int duration) {
            this.start = start;
            this.end = end;
            this.duration = duration;
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            return this.lerpRotation(index, delta, Movement::getWingRotation);
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            return this.lerpRotation(index, delta, Movement::getFeatherRotation);
        }

        private Vec3 lerpRotation(int index, float delta, RotationGetter getter) {
            Vec3 startRot = getter.get(this.start, index, delta);
            Vec3 endRot = getter.get(this.end, index, delta);
            float t = MathH.easeInOut(MathH.lerp(this.lastTime, this.time, delta) / (float)this.duration);
            return new Vec3(MathH.lerpDegrees(startRot.x, endRot.x, (double)t), MathH.lerpDegrees(startRot.y, endRot.y, (double)t), MathH.lerpDegrees(startRot.z, endRot.z, (double)t));
        }

        @Override
        public float update() {
            this.lastTime = this.time;
            float flapStart = this.start.update();
            float flapEnd = this.end.update();
            float flap = MathH.lerp(flapStart, flapEnd, (float)this.time / (float)this.duration);
            if (this.time < this.duration) {
                ++this.time;
            } else if (this.isActive) {
                AnimatorAvian.this.setMovement(this.end);
            }
            return flap;
        }

        @Override
        public void onEnd() {
            this.isActive = false;
        }
    }

    private final class LandMovement
    implements Movement {
        private LandMovement() {
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            float pos = AnimatorAvian.this.getWeight(index + 1);
            float time = AnimatorAvian.this.getFlapTime(delta);
            float cycle = time - pos * 1.2f;
            double x = (Math.sin((double)cycle + 1.5707963705062866) - 1.0) / 2.0 * 20.0 + (1.0 - (double)pos) * 50.0;
            double y = (Math.sin(cycle) * 20.0 + (1.0 - (double)pos) * 14.0) * (1.0 - (double)pos * (Math.min(Math.sin(cycle + (float)Math.PI), 0.0) / 2.0 + 1.0) * Math.sin(time));
            return AnimatorAvian.this.restPosition.getWingRotation(index, delta).add(new Vec3(x, y, 4.0));
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            return AnimatorAvian.this.restPosition.getFeatherRotation(index, delta);
        }

        @Override
        public float update() {
            return 0.67f;
        }
    }

    private final class GlideMovement
    implements Movement {
        private final SimplexNoise noise = new SimplexNoise((RandomSource)new LegacyRandomSource(new Random().nextLong()));
        private int time;

        private GlideMovement() {
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            float pos = AnimatorAvian.this.getWeight(index);
            float time = AnimatorAvian.this.getFlapTime(delta);
            double y = (Math.sin(time) * 5.0 - 14.0) * (double)pos;
            return AnimatorAvian.this.restPosition.getWingRotation(index, delta).add(0.0, y, 0.0);
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            double x = this.noise.getValue((double)((float)this.time + delta) * 0.17, (double)index * 0.13) * 1.25;
            return AnimatorAvian.this.restPosition.getFeatherRotation(index, delta).add(x, 0.0, 0.0);
        }

        @Override
        public float update() {
            ++this.time;
            return 0.045f;
        }
    }

    private final class LiftMovement
    implements Movement {
        private final int beginDuration = 100;
        private int beginTime;

        private LiftMovement() {
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            float pos = AnimatorAvian.this.getWeight(index);
            float time = AnimatorAvian.this.getFlapTime(delta);
            float cycle = time - pos * 1.2f;
            double x = (Math.sin((double)cycle + 1.5707963705062866) - 1.0) / 2.0 * 16.0 + 8.0;
            double y = (Math.sin(cycle) * 26.0 + 12.0) * (1.0 - (double)pos * (Math.min(Math.sin(cycle + (float)Math.PI), 0.0) / 2.0 + 1.0) * Math.sin(time));
            return AnimatorAvian.this.restPosition.getWingRotation(index, delta).add(x, y, 0.0);
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            return AnimatorAvian.this.restPosition.getFeatherRotation(index, delta);
        }

        @Override
        public float update() {
            float f = this.beginTime;
            Objects.requireNonNull(this);
            float flap = MathH.lerp(0.375f, 0.225f, f / 100.0f);
            if (this.beginTime < this.beginDuration) {
                ++this.beginTime;
            }
            return flap;
        }
    }

    private final class FallMovement
    implements Movement {
        private final SimplexNoise noise = new SimplexNoise((RandomSource)new LegacyRandomSource(new Random().nextLong()));
        private final WingPose wing = WingPose.builder().with(0, 30.0, -23.0, -50.0).with(1, -10.0, 5.0, -10.0).with(2, -30.0, -20.0, -20.0).with(3, -20.0, 0.0, 20.0).build();
        private int time;

        private FallMovement(AnimatorAvian animatorAvian) {
        }

        @Override
        public Vec3 getWingRotation(int index, float delta) {
            double n = this.noise.getValue((double)((float)this.time + delta) * 0.18, (double)index * 0.13) * 0.92 * (double)(index + 1);
            return this.wing.get(index).add(n, 0.0, n);
        }

        @Override
        public Vec3 getFeatherRotation(int index, float delta) {
            double n = this.noise.getValue((double)((float)this.time + delta) * 0.2, (double)index * 0.13) * 1.75;
            return new Vec3(-n, n * 4.0, 0.0);
        }

        @Override
        public float update() {
            ++this.time;
            return 0.0f;
        }
    }

    private static final class WingPose {
        private final ImmutableMap<Integer, Vec3> rotations;

        private WingPose(ImmutableMap<Integer, Vec3> rotations) {
            this.rotations = rotations;
        }

        public Vec3 get(int index) {
            return (Vec3)this.rotations.getOrDefault((Object)index, (Object)Vec3.ZERO);
        }

        private static Builder builder() {
            return new Builder();
        }

        private static final class Builder {
            private final ImmutableMap.Builder<Integer, Vec3> rotations = ImmutableMap.builder();

            private Builder() {
            }

            private Builder with(int index, double x, double y, double z) {
                this.rotations.put((Object)index, (Object)new Vec3(x, y, z));
                return this;
            }

            private WingPose build() {
                return new WingPose((ImmutableMap<Integer, Vec3>)this.rotations.build());
            }
        }
    }

    @FunctionalInterface
    private static interface RotationGetter {
        public Vec3 get(Movement var1, int var2, float var3);
    }
}

