/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.flight;

import com.toni.wings.client.flight.FlightView;
import com.toni.wings.client.flight.FlightViewDefault;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.Flights;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class FlightViews {
    private static final Map<AbstractClientPlayer, FlightView> VIEWS = Collections.synchronizedMap(new WeakHashMap());

    private FlightViews() {
    }

    public static boolean has(LivingEntity entity) {
        return FlightViews.get(entity).isPresent();
    }

    public static Optional<FlightView> get(LivingEntity entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            return Flights.get((Player)player).map(flight -> VIEWS.computeIfAbsent(player, ignored -> new FlightViewDefault((Player)player, (Flight)flight)));
        }
        return Optional.empty();
    }

    public static void invalidate(AbstractClientPlayer player) {
        VIEWS.remove(player);
    }
}

