/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.dreamcatcher;

import com.toni.wings.WingsAttachments;
import com.toni.wings.WingsMod;
import com.toni.wings.server.dreamcatcher.InSomniable;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="wings")
public final class InSomniableCapability {
    public static final EntityCapability<InSomniable, Void> INSOMNIABLE_CAPABILITY = EntityCapability.createVoid((ResourceLocation)WingsMod.locate("insomniable"), InSomniable.class);

    private InSomniableCapability() {
    }

    public static Optional<InSomniable> getInSomniable(Player player) {
        return Optional.ofNullable((InSomniable)player.getCapability(INSOMNIABLE_CAPABILITY));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        InSomniableCapability.getInSomniable(event.getOriginal()).ifPresent(oldInstance -> InSomniableCapability.getInSomniable(event.getEntity()).ifPresent(newInstance -> newInstance.clone((InSomniable)oldInstance)));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(INSOMNIABLE_CAPABILITY, EntityType.PLAYER, (player, ctx) -> (InSomniable)player.getData((AttachmentType)WingsAttachments.INSOMNIABLE.get()));
    }
}

