/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.apparatus;

import com.toni.wings.client.flight.Animator;
import com.toni.wings.client.model.ModelWings;
import com.toni.wings.server.apparatus.FlightApparatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public final class WingForm<A extends Animator> {
    private static final Map<FlightApparatus, WingForm<?>> FORMS = new HashMap();
    private final Supplier<A> animator;
    private ModelWings<A> model;
    private final ResourceLocation texture;
    private final Supplier<RenderType> renderType;

    private WingForm(Supplier<A> animator, ModelWings<A> model, ResourceLocation texture, Supplier<RenderType> renderType) {
        this.animator = Objects.requireNonNull(animator);
        this.model = Objects.requireNonNull(model);
        this.texture = Objects.requireNonNull(texture);
        this.renderType = Objects.requireNonNull(renderType);
    }

    public A createAnimator() {
        return (A)((Animator)this.animator.get());
    }

    public ModelWings<A> getModel() {
        return this.model;
    }

    public void setModel(ModelWings<A> model) {
        this.model = model;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public static <A extends Animator> WingForm<A> of(Supplier<A> animator, ModelWings<A> model, ResourceLocation texture) {
        return new WingForm<A>(animator, model, texture, () -> RenderType.m_110452_((ResourceLocation)texture));
    }

    public static <A extends Animator> WingForm<A> of(Supplier<A> animator, ModelWings<A> model, ResourceLocation texture, Supplier<RenderType> renderType) {
        return new WingForm<A>(animator, model, texture, renderType);
    }

    public RenderType getRenderType() {
        return this.renderType.get();
    }

    public static Optional<WingForm<?>> get(FlightApparatus wings) {
        return Optional.ofNullable(FORMS.get(wings));
    }

    public static void register(FlightApparatus wings, WingForm<?> form) {
        FORMS.put(wings, form);
    }

    public static Map<FlightApparatus, WingForm<?>> getFormsMap() {
        return FORMS;
    }

    public static boolean isEmpty() {
        return FORMS.isEmpty();
    }
}

