/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.flight.state;

import com.toni.wings.client.flight.Animator;
import com.toni.wings.client.flight.state.StateFall;
import com.toni.wings.client.flight.state.StateGlide;
import com.toni.wings.client.flight.state.StateIdle;
import com.toni.wings.client.flight.state.StateLand;
import com.toni.wings.client.flight.state.StateLift;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.util.MathH;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public abstract class State {
    static final int STATE_DELAY = 2;
    private final int stateDelay;
    private final Consumer<Animator> animation;
    private int time;

    protected State(Consumer<Animator> animation) {
        this(2, animation);
    }

    protected State(int stateDelay, Consumer<Animator> animation) {
        this.stateDelay = stateDelay;
        this.animation = animation;
    }

    public final State update(Flight flight, double x, double y, double z, Player player) {
        if (this.time++ > this.stateDelay) {
            return this.getNext(flight, x, y, z, player);
        }
        return this;
    }

    private State getNext(Flight flight, double x, double y, double z, Player player) {
        if (flight.isFlying()) {
            if (y < 0.0 && player.getXRot() >= this.getPitch(x, y, z)) {
                return this.createGlide();
            }
            return this.createLift();
        }
        if (y < 0.0) {
            return this.getDescent(flight, player);
        }
        return this.getDefault(y);
    }

    private float getPitch(double x, double y, double z) {
        return MathH.toDegrees((float)(-Math.atan2(y, Mth.sqrt((float)((float)(x * x + z * z))))));
    }

    public final void beginAnimation(Animator animator) {
        this.animation.accept(animator);
    }

    protected State createLand() {
        return new StateLand();
    }

    protected State createLift() {
        return new StateLift();
    }

    protected State createGlide() {
        return new StateGlide();
    }

    protected State createIdle() {
        return new StateIdle();
    }

    protected State createFall() {
        return new StateFall();
    }

    protected State getDefault(double y) {
        return this.createIdle();
    }

    protected State getDescent(Flight flight, Player player) {
        return flight.canLand(player) ? this.createLand() : this.createFall();
    }
}

