/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.cosmos.mixin;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.hollowed.cosmos.Cosmos;
import net.hollowed.cosmos.config.CosmosConfig;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_10537;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9975;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9975.class})
public class SkyRenderingMixin {
    @Unique
    private static final RenderPipeline POSITION_TEXTURE_COLOR_STARS = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withLocation("pipeline/stars").withVertexShader("core/cosmos_stars").withFragmentShader("core/cosmos_stars").withBlend(BlendFunction.OVERLAY).withDepthWrite(false).withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27382).build());
    @Unique
    private int cosmosStarIndexCount;
    @Shadow
    @Final
    private RenderSystem.class_5590 field_57935;
    @Unique
    private GpuBuffer cosmosStarVertexBuffer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.cosmosStarVertexBuffer = this.createCosmosStars();
    }

    @Unique
    private GpuBuffer createCosmosStars() {
        GpuBuffer var19;
        class_5819 random = class_5819.method_43049((long)12936L);
        try (class_9799 bufferAllocator = class_9799.method_72201((int)(class_290.field_1575.getVertexSize() * CosmosConfig.starCount * 4));){
            class_287 bufferBuilder = new class_287(bufferAllocator, VertexFormat.class_5596.field_27382, class_290.field_1575);
            boolean northStar = false;
            int limit = CosmosConfig.northStar ? 1 : 0;
            for (int i = 0; i < CosmosConfig.starCount; ++i) {
                float l;
                float g = random.method_43057() * 2.0f - 1.0f;
                float h = random.method_43057() * 2.0f - 1.0f;
                float j = random.method_43057() * 2.0f - 1.0f;
                float k = CosmosConfig.sizeRange.getFirst().floatValue() + random.method_43057() * (CosmosConfig.sizeRange.get(1).floatValue() - CosmosConfig.sizeRange.getFirst().floatValue());
                if (g < -0.48f && h < -0.23f && h > -0.32f && Math.abs(j) < 0.07f && limit > 0) {
                    k = CosmosConfig.sizeRange.get(1).floatValue() * 1.3f;
                    northStar = true;
                    --limit;
                }
                if ((l = class_3532.method_60677((float)g, (float)h, (float)j)) <= 0.010000001f || l >= 1.0f) continue;
                Vector3f vector3f = new Vector3f(g, h, j).normalize(100.0f);
                float m = (float)(random.method_43058() * 3.1415927410125732 * 2.0);
                Matrix3f matrix3f = new Matrix3f().rotateTowards((Vector3fc)new Vector3f((Vector3fc)vector3f).negate(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-m);
                int alpha = CosmosConfig.alphaRange.getFirst() + random.method_43048(CosmosConfig.alphaRange.get(1) - CosmosConfig.alphaRange.getFirst());
                String colorString = CosmosConfig.colors.get(random.method_43048(CosmosConfig.colors.size()));
                int[] colorEntry = SkyRenderingMixin.hexToRGB(colorString);
                int color = class_9848.method_61324((int)alpha, (int)colorEntry[0], (int)colorEntry[1], (int)colorEntry[2]);
                if (northStar) {
                    color = class_9848.method_61324((int)255, (int)255, (int)255, (int)255);
                    northStar = false;
                }
                bufferBuilder.method_60830(new Vector3f(k, -k, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f)).method_22913(0.0f, 0.0f).method_39415(color);
                bufferBuilder.method_60830(new Vector3f(k, k, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f)).method_22913(0.0f, 1.0f).method_39415(color);
                bufferBuilder.method_60830(new Vector3f(-k, k, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f)).method_22913(1.0f, 1.0f).method_39415(color);
                bufferBuilder.method_60830(new Vector3f(-k, -k, 0.0f).mul((Matrix3fc)matrix3f).add((Vector3fc)vector3f)).method_22913(1.0f, 0.0f).method_39415(color);
            }
            try (class_9801 builtBuffer = bufferBuilder.method_60800();){
                this.cosmosStarIndexCount = builtBuffer.method_60822().comp_751();
                var19 = RenderSystem.getDevice().createBuffer(() -> "Stars vertex buffer", 40, builtBuffer.method_60818());
            }
        }
        return var19;
    }

    @Inject(method={"renderStars"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderStars(float brightness, class_4587 matrices, CallbackInfo ci) {
        if (CosmosConfig.enabled) {
            if (class_310.method_1551().field_1687 != null) {
                brightness *= (float)CosmosConfig.brightnessMultiplier;
                class_2960 starTextureId = Cosmos.id("textures/environment/star.png");
                class_1060 textureManager = class_310.method_1551().method_1531();
                textureManager.method_65876(starTextureId, (class_10537)new class_1049(starTextureId));
                class_1044 abstractTexture = textureManager.method_4619(starTextureId);
                abstractTexture.method_70950(false);
                abstractTexture.method_4527(false, false);
                Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
                matrix4fStack.pushMatrix();
                matrix4fStack.mul((Matrix4fc)matrices.method_23760().method_23761());
                GpuTextureView gpuTextureView = class_310.method_1551().method_1522().method_71639();
                GpuTextureView gpuTextureView2 = class_310.method_1551().method_1522().method_71640();
                GpuBuffer gpuBuffer = this.field_57935.method_68274(this.cosmosStarIndexCount);
                float time = (float)(class_310.method_1551().field_1687.method_8510() % 24000L) / 20.0f;
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)matrix4fStack, (Vector4fc)new Vector4f(brightness, CosmosConfig.twinkleFrequency.getFirst().floatValue(), CosmosConfig.twinkleFrequency.get(1).floatValue(), brightness), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), time);
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Stars", gpuTextureView, OptionalInt.empty(), gpuTextureView2, OptionalDouble.empty());){
                    renderPass.setPipeline(POSITION_TEXTURE_COLOR_STARS);
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                    renderPass.bindSampler("Sampler0", abstractTexture.method_71659());
                    renderPass.setVertexBuffer(0, this.cosmosStarVertexBuffer);
                    renderPass.setIndexBuffer(gpuBuffer, this.field_57935.method_31924());
                    renderPass.drawIndexed(0, 0, this.cosmosStarIndexCount, 1);
                }
                matrix4fStack.popMatrix();
            }
            ci.cancel();
        }
    }

    @Unique
    private static int[] hexToRGB(String hexColor) {
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        if (hexColor.length() < 6) {
            hexColor = "FFFFFF";
        }
        int red = Integer.parseInt(hexColor.substring(0, 2), 16);
        int green = Integer.parseInt(hexColor.substring(2, 4), 16);
        int blue = Integer.parseInt(hexColor.substring(4, 6), 16);
        return new int[]{red, green, blue};
    }
}

