/*
 * Decompiled with CFR 0.152.
 */
package drqad.fairXaero;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class XaeroForceDisabler
extends JavaPlugin
implements Listener,
TabCompleter {
    private volatile boolean autoDisableEnabled = false;
    private volatile boolean autoFairEnabled = false;
    private volatile boolean debugEnabled = false;
    private Logger logger;
    private volatile boolean isReloading = false;

    public void onEnable() {
        try {
            this.saveDefaultConfig();
            this.loadConfiguration();
            this.logger = this.getLogger();
            if (this.debugEnabled) {
                this.logger.info("Debugging is enabled");
            }
            this.registerCommands();
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            this.logger.info("FairXaero has been enabled successfully!");
        }
        catch (Exception var2) {
            this.logger.severe("Failed to enable FairXaero: " + var2.getMessage());
            var2.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        try {
            HandlerList.unregisterAll((Plugin)this);
            this.saveConfig();
            this.logger.info("FairXaero has been disabled successfully!");
        }
        catch (Exception var2) {
            this.logger.severe("Error during plugin disable: " + var2.getMessage());
        }
    }

    private void loadConfiguration() {
        FileConfiguration config = this.getConfig();
        this.autoDisableEnabled = config.getBoolean("auto-settings.auto-disable", false);
        this.autoFairEnabled = config.getBoolean("auto-settings.auto-fair", false);
        this.debugEnabled = config.getBoolean("debug", false);
    }

    private void registerCommands() {
        if (this.getCommand("xaero") != null) {
            this.getCommand("xaero").setTabCompleter((TabCompleter)this);
        } else {
            this.logger.severe("Failed to register 'xaero' command!");
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("xaero")) {
            return false;
        }
        if (!sender.isOp() && !sender.hasPermission("xaero.edit")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendCommandPreview(sender);
            return true;
        }
        if (this.debugEnabled) {
            this.logger.info("Command received: " + String.join((CharSequence)" ", args));
        }
        try {
            switch (args[0].toLowerCase()) {
                case "disable": {
                    this.sendTellrawAsync("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p");
                    return true;
                }
                case "fair": {
                    this.sendTellrawAsync("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o");
                    return true;
                }
                case "reset": {
                    this.handleReset(sender);
                    return true;
                }
                case "reload": {
                    this.handleReload(sender);
                    return true;
                }
                case "fairnether": {
                    this.sendTellrawAsync("\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r");
                    return true;
                }
                case "autodisable": {
                    this.toggleAutoDisable(sender);
                    return true;
                }
                case "autofair": {
                    this.toggleAutoFair(sender);
                    return true;
                }
            }
            sender.sendMessage("\u00a7cUnknown command. Use /xaero for help.");
            return true;
        }
        catch (Exception var7) {
            this.logger.severe("Error executing command: " + var7.getMessage());
            sender.sendMessage("\u00a7cAn error occurred while executing the command.");
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!sender.isOp() && !sender.hasPermission("xaero.edit")) {
            return suggestions;
        }
        if (cmd.getName().equalsIgnoreCase("xaero") && args.length == 1) {
            suggestions.add("disable");
            suggestions.add("fair");
            suggestions.add("reset");
            suggestions.add("fairnether");
            suggestions.add("autodisable");
            suggestions.add("autofair");
            suggestions.add("reload");
        }
        return suggestions;
    }

    private void sendTellrawAsync(String message) {
        CompletableFuture.runAsync(() -> Bukkit.getScheduler().runTask((Plugin)this, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw @a \"" + message + "\""))));
    }

    private void sendTellrawToPlayer(String playerName, String message) {
        CompletableFuture.runAsync(() -> Bukkit.getScheduler().runTask((Plugin)this, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + playerName + " \"" + message + "\""))));
    }

    private void handleReset(CommandSender sender) {
        this.autoDisableEnabled = false;
        this.autoFairEnabled = false;
        FileConfiguration config = this.getConfig();
        config.set("auto-settings.auto-disable", (Object)false);
        config.set("auto-settings.auto-fair", (Object)false);
        this.saveConfig();
        this.sendTellrawAsync("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o");
        sender.sendMessage("\u00a7aAuto modes have been disabled");
    }

    private synchronized void handleReload(CommandSender sender) {
        if (this.isReloading) {
            sender.sendMessage("\u00a7cPlugin is already reloading!");
        } else {
            try {
                this.isReloading = true;
                this.reloadConfig();
                this.loadConfiguration();
                sender.sendMessage("\u00a7aConfiguration reloaded successfully!");
                if (this.debugEnabled) {
                    this.logger.info("Configuration reloaded");
                }
            }
            catch (Exception var6) {
                this.logger.severe("Error reloading configuration: " + var6.getMessage());
                sender.sendMessage("\u00a7cError reloading configuration!");
            }
            finally {
                this.isReloading = false;
            }
        }
    }

    private void toggleAutoDisable(CommandSender sender) {
        this.autoDisableEnabled = !this.autoDisableEnabled;
        this.updateConfig("auto-settings.auto-disable", this.autoDisableEnabled);
        sender.sendMessage("\u00a7aAuto Disable: " + (this.autoDisableEnabled ? "\u00a72Enabled" : "\u00a7cDisabled"));
        if (this.debugEnabled) {
            this.logger.info("Auto Disable toggled: " + this.autoDisableEnabled);
        }
        if (this.autoDisableEnabled) {
            this.sendTellrawAsync("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p");
        }
    }

    private void toggleAutoFair(CommandSender sender) {
        this.autoFairEnabled = !this.autoFairEnabled;
        this.updateConfig("auto-settings.auto-fair", this.autoFairEnabled);
        sender.sendMessage("\u00a7aAuto Fair: " + (this.autoFairEnabled ? "\u00a72Enabled" : "\u00a7cDisabled"));
        if (this.debugEnabled) {
            this.logger.info("Auto Fair toggled: " + this.autoFairEnabled);
        }
        if (this.autoFairEnabled) {
            this.sendTellrawAsync("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o");
        }
    }

    private synchronized void updateConfig(String path, boolean value) {
        FileConfiguration config = this.getConfig();
        config.set(path, (Object)value);
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        try {
            String playerName = event.getPlayer().getName();
            if (this.autoDisableEnabled) {
                this.sendTellrawToPlayer(playerName, "\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p");
            }
            if (this.autoFairEnabled) {
                this.sendTellrawToPlayer(playerName, "\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o");
            }
            if (this.debugEnabled) {
                this.logger.info("Player joined: " + playerName);
            }
        }
        catch (Exception var3) {
            this.logger.severe("Error handling player join event: " + var3.getMessage());
        }
    }

    private void sendCommandPreview(CommandSender sender) {
        sender.sendMessage("\u00a76XaeroUtils Commands:");
        sender.sendMessage("\u00a7e/xaero disable \u00a77- Broadcasts disable message");
        sender.sendMessage("\u00a7e/xaero fair \u00a77- Broadcasts fair message");
        sender.sendMessage("\u00a7e/xaero reset \u00a77- Broadcasts reset message");
        sender.sendMessage("\u00a7e/xaero fairnether \u00a77- Broadcasts fairnether message");
        sender.sendMessage("\u00a7e/xaero autodisable \u00a77- Toggles auto disable on join");
        sender.sendMessage("\u00a7e/xaero autofair \u00a77- Toggles auto fair on join");
        sender.sendMessage("\u00a7e/xaero reload \u00a77- Reloads the configuration");
    }
}

