/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.ingotcraft.init;

import com.jahirtrap.ingotcraft.init.ModMaterials;
import com.jahirtrap.ingotcraft.item.BasePickHammerItem;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModContent {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ingotcraft");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ingotcraft");
    public static final DeferredItem<Item> RAW_STEEL = ModContent.registerItem("raw_steel", Item::new, new Item.Properties());
    public static final DeferredItem<Item> RAW_BRONZE = ModContent.registerItem("raw_bronze", Item::new, new Item.Properties());
    public static final DeferredItem<Item> RAW_LEAD = ModContent.registerItem("raw_lead", Item::new, new Item.Properties());
    public static final DeferredItem<Item> RAW_SILVER = ModContent.registerItem("raw_silver", Item::new, new Item.Properties());
    public static final DeferredItem<Item> RAW_TIN = ModContent.registerItem("raw_tin", Item::new, new Item.Properties());
    public static DeferredBlock<Block> RAW_STEEL_BLOCK = ModContent.registerBlock("raw_steel_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> RAW_BRONZE_BLOCK = ModContent.registerBlock("raw_bronze_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> RAW_LEAD_BLOCK = ModContent.registerBlock("raw_lead_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> RAW_SILVER_BLOCK = ModContent.registerBlock("raw_silver_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> RAW_TIN_BLOCK = ModContent.registerBlock("raw_tin_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static final DeferredItem<Item> STEEL_INGOT = ModContent.registerItem("steel_ingot", Item::new, new Item.Properties());
    public static final DeferredItem<Item> BRONZE_INGOT = ModContent.registerItem("bronze_ingot", Item::new, new Item.Properties());
    public static final DeferredItem<Item> LEAD_INGOT = ModContent.registerItem("lead_ingot", Item::new, new Item.Properties());
    public static final DeferredItem<Item> SILVER_INGOT = ModContent.registerItem("silver_ingot", Item::new, new Item.Properties());
    public static final DeferredItem<Item> TIN_INGOT = ModContent.registerItem("tin_ingot", Item::new, new Item.Properties());
    public static DeferredBlock<Block> STEEL_BLOCK = ModContent.registerBlock("steel_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> BRONZE_BLOCK = ModContent.registerBlock("bronze_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> LEAD_BLOCK = ModContent.registerBlock("lead_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).sound(SoundType.COPPER).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> SILVER_BLOCK = ModContent.registerBlock("silver_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static DeferredBlock<Block> TIN_BLOCK = ModContent.registerBlock("tin_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), new Item.Properties());
    public static final DeferredItem<Item> STEEL_NUGGET = ModContent.registerItem("steel_nugget", Item::new, new Item.Properties());
    public static final DeferredItem<Item> BRONZE_NUGGET = ModContent.registerItem("bronze_nugget", Item::new, new Item.Properties());
    public static final DeferredItem<Item> LEAD_NUGGET = ModContent.registerItem("lead_nugget", Item::new, new Item.Properties());
    public static final DeferredItem<Item> SILVER_NUGGET = ModContent.registerItem("silver_nugget", Item::new, new Item.Properties());
    public static final DeferredItem<Item> TIN_NUGGET = ModContent.registerItem("tin_nugget", Item::new, new Item.Properties());
    public static final List<DeferredItem<Item>> STEEL_TOOLS = ModContent.registerTools("steel", ModMaterials.Tool.STEEL, new float[]{6.0f, -3.0f, -2.0f, -1.0f}, new Item.Properties());
    public static final List<DeferredItem<Item>> BRONZE_TOOLS = ModContent.registerTools("bronze", ModMaterials.Tool.BRONZE, new float[]{6.0f, -3.0f, -2.0f, -1.0f}, new Item.Properties());
    public static final List<DeferredItem<Item>> STEEL_ARMOR = ModContent.registerArmor(ModMaterials.Armor.STEEL, new Item.Properties());
    public static final List<DeferredItem<Item>> BRONZE_ARMOR = ModContent.registerArmor(ModMaterials.Armor.BRONZE, new Item.Properties());
    public static final DeferredItem<Item> STONE_PICK_HAMMER = ModContent.registerItem("stone_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.STONE_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> COPPER_PICK_HAMMER = ModContent.registerItem("copper_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.COPPER_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> IRON_PICK_HAMMER = ModContent.registerItem("iron_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.IRON_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> GOLDEN_PICK_HAMMER = ModContent.registerItem("golden_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.GOLD_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> DIAMOND_PICK_HAMMER = ModContent.registerItem("diamond_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.DIAMOND_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> NETHERITE_PICK_HAMMER = ModContent.registerItem("netherite_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.NETHERITE_PICK_HAMMER, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final DeferredItem<Item> ENDERITE_PICK_HAMMER = ModContent.registerItem("enderite_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.ENDERITE_PICK_HAMMER, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final DeferredItem<Item> STEEL_PICK_HAMMER = ModContent.registerItem("steel_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.STEEL_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> BRONZE_PICK_HAMMER = ModContent.registerItem("bronze_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.BRONZE_PICK_HAMMER, (Item.Properties)p), new Item.Properties());
    public static final DeferredItem<Item> ZURITE_PICK_HAMMER = ModContent.registerItem("zurite_pick_hammer", p -> new BasePickHammerItem(ModMaterials.Tool.ZURITE_PICK_HAMMER, (Item.Properties)p), new Item.Properties().fireResistant());

    private static DeferredBlock<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp, Item.Properties itemProp) {
        DeferredBlock<Block> blockReg = ModContent.registerBlock(name, function, blockProp);
        ModContent.registerItem(name, p -> new BlockItem((Block)blockReg.get(), p), itemProp.useBlockDescriptionPrefix());
        return blockReg;
    }

    private static DeferredBlock<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp) {
        return BLOCKS.register(name, () -> (Block)function.apply(blockProp.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ingotcraft", (String)name)))));
    }

    private static DeferredItem<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ingotcraft", (String)name)))));
    }

    private static List<DeferredItem<Item>> registerTools(String name, ToolMaterial material, float[] attr, Item.Properties itemProp) {
        return List.of(ModContent.registerItem(name + "_sword", p -> new Item(p.sword(material, 3.0f, -2.4f)), itemProp), ModContent.registerItem(name + "_pickaxe", p -> new Item(p.pickaxe(material, 1.0f, -2.8f)), itemProp), ModContent.registerItem(name + "_axe", p -> new AxeItem(material, attr[0], attr[1], p), itemProp), ModContent.registerItem(name + "_shovel", p -> new ShovelItem(material, 1.5f, -3.0f, p), itemProp), ModContent.registerItem(name + "_hoe", p -> new HoeItem(material, attr[2], attr[3], p), itemProp));
    }

    private static List<DeferredItem<Item>> registerArmor(ArmorMaterial material, Item.Properties itemProp) {
        String name = material.assetId().location().getPath();
        return List.of(ModContent.registerItem(name + "_helmet", p -> new Item(p.humanoidArmor(material, ArmorType.HELMET)), itemProp), ModContent.registerItem(name + "_chestplate", p -> new Item(p.humanoidArmor(material, ArmorType.CHESTPLATE)), itemProp), ModContent.registerItem(name + "_leggings", p -> new Item(p.humanoidArmor(material, ArmorType.LEGGINGS)), itemProp), ModContent.registerItem(name + "_boots", p -> new Item(p.humanoidArmor(material, ArmorType.BOOTS)), itemProp));
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }
}

