/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.ingotcraft.init;

import com.jahirtrap.ingotcraft.init.ModTags;
import java.util.EnumMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public class ModMaterials {

    public static interface Tool {
        public static final ToolMaterial STEEL = new ToolMaterial(BlockTags.INCORRECT_FOR_IRON_TOOL, 501, 6.5f, 2.0f, 14, ModTags.Items.STEEL_INGOTS);
        public static final ToolMaterial BRONZE = new ToolMaterial(BlockTags.INCORRECT_FOR_IRON_TOOL, 350, 7.0f, 2.0f, 16, ModTags.Items.BRONZE_INGOTS);
        public static final ToolMaterial STONE_PICK_HAMMER = Tool.copy(ToolMaterial.STONE, 1, 1.0f);
        public static final ToolMaterial COPPER_PICK_HAMMER = Tool.copy(ToolMaterial.COPPER, 1, 1.0f);
        public static final ToolMaterial IRON_PICK_HAMMER = Tool.copy(ToolMaterial.IRON, 1, 1.0f);
        public static final ToolMaterial GOLD_PICK_HAMMER = Tool.copy(ToolMaterial.GOLD, 5, 1.0f);
        public static final ToolMaterial DIAMOND_PICK_HAMMER = Tool.copy(ToolMaterial.DIAMOND, 1, 1.0f);
        public static final ToolMaterial NETHERITE_PICK_HAMMER = Tool.copy(ToolMaterial.NETHERITE, 1, 1.0f);
        public static final ToolMaterial STEEL_PICK_HAMMER = Tool.copy(STEEL, 1, 1.0f);
        public static final ToolMaterial BRONZE_PICK_HAMMER = Tool.copy(BRONZE, 1, 1.0f);
        public static final ToolMaterial ZURITE_PICK_HAMMER = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 1320, 9.5f, 4.0f, 16, ModTags.Items.ZURITE_INGOTS);
        public static final ToolMaterial ENDERITE_PICK_HAMMER = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 4096, 16.0f, 5.0f, 17, ModTags.Items.ENDERITE_INGOTS);

        private static ToolMaterial copy(ToolMaterial material, int i, float j) {
            return new ToolMaterial(material.incorrectBlocksForDrops(), material.durability() * i, material.speed() + j, material.attackDamageBonus(), material.enchantmentValue(), material.repairItems());
        }
    }

    public static interface Armor {
        public static final ArmorMaterial STEEL = new ArmorMaterial(25, Armor.createMap(new int[]{2, 5, 6, 2, 5}), 9, SoundEvents.ARMOR_EQUIP_IRON, 1.0f, 0.0f, ModTags.Items.STEEL_INGOTS, Armor.createAsset("steel"));
        public static final ArmorMaterial BRONZE = new ArmorMaterial(15, Armor.createMap(new int[]{2, 5, 6, 2, 5}), 16, SoundEvents.ARMOR_EQUIP_GOLD, 0.0f, 0.0f, ModTags.Items.BRONZE_INGOTS, Armor.createAsset("bronze"));

        private static EnumMap<ArmorType, Integer> createMap(int[] values) {
            EnumMap<ArmorType, Integer> enumMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
            for (int i = 0; i < values.length; ++i) {
                enumMap.put(ArmorType.values()[i], values[i]);
            }
            return enumMap;
        }

        private static ResourceKey<EquipmentAsset> createAsset(String name) {
            return ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ingotcraft", (String)name));
        }
    }
}

