/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.underground_village.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.reggarf.mods.underground_village.Underground_village;
import com.reggarf.mods.underground_village.register.USStructures;
import com.reggarf.mods.underground_village.utilities.FilterHolderSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class UnderwaterStructures
extends Structure {
    public static final MapCodec<Structure.StructureSettings> CUSTOM_STRUCTURE_SETTINGS_CODEC = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)FilterHolderSet.codec(Registries.BIOME, Biome.CODEC, false).fieldOf("biomes").forGetter(x -> {
        FilterHolderSet filterHolderSet;
        HolderSet patt0$temp = x.biomes();
        if (patt0$temp instanceof FilterHolderSet) {
            FilterHolderSet filterHolderSet2 = (FilterHolderSet)patt0$temp;
            filterHolderSet = filterHolderSet2;
        } else {
            filterHolderSet = new FilterHolderSet(x.biomes(), HolderSet.empty());
        }
        return filterHolderSet;
    }), (App)Codec.simpleMap((Codec)MobCategory.CODEC, (Codec)StructureSpawnOverride.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(Structure.StructureSettings::spawnOverrides), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(Structure.StructureSettings::step), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[0]), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE).terrainAdaptation()).forGetter(Structure.StructureSettings::terrainAdaptation)).apply((Applicative)codecBuilder, Structure.StructureSettings::new));
    public static final MapCodec<UnderwaterStructures> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CUSTOM_STRUCTURE_SETTINGS_CODEC.forGetter(structureInfo -> structureInfo.modifiableStructureInfo().getOriginalStructureInfo().structureSettings()), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> Underground_village.CONFIG.common.watermaxDistanceFromCenter), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)JigsawStructure.DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.IGNORE_WATERLOGGING).forGetter(s -> s.liquidSettings)).apply((Applicative)instance, UnderwaterStructures::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    public UnderwaterStructures(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = Underground_village.CONFIG.common.waterstructureSize;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = Underground_village.CONFIG.common.watermaxDistanceFromCenter;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int x = chunkPos.getMinBlockX();
        int z = chunkPos.getMinBlockZ();
        int surfaceY = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        NoiseColumn column = context.chunkGenerator().getBaseColumn(x, z, context.heightAccessor(), context.randomState());
        BlockState surfaceBlock = column.getBlock(surfaceY);
        if (!surfaceBlock.getFluidState().is(FluidTags.WATER)) {
            return false;
        }
        int requiredWaterDepth = 25;
        for (int y = surfaceY - 1; y > surfaceY - requiredWaterDepth - 1; --y) {
            BlockState below = column.getBlock(y);
            if (below.getFluidState().is(FluidTags.WATER)) continue;
            return false;
        }
        BlockState bottomBlock = column.getBlock(surfaceY - requiredWaterDepth);
        if (bottomBlock.isSolid()) {
            return true;
        }
        return true;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!UnderwaterStructures.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        ChunkPos chunkPos = context.chunkPos();
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), startY, chunkPos.getMinBlockZ());
        Optional structurePiecesGenerator = JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
        return structurePiecesGenerator;
    }

    public StructureType<?> type() {
        return (StructureType)USStructures.UNDERWATER_STRUCTURES.get();
    }
}

