/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.orcinus.galosphere.blocks.blockentities.MoleBurrowBlockEntity;
import net.orcinus.galosphere.entities.ai.MoleAi;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityDataSerializers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import org.jetbrains.annotations.Nullable;

public class Mole
extends class_1429 {
    private static final class_2940<State> DATA_STATE = class_2945.method_12791(Mole.class, GEntityDataSerializers.MOLE_STATE);
    public final class_7094 twitchAnimationState = new class_7094();
    public final class_7094 sniffAnimationState = new class_7094();
    public final class_7094 emergeAnimationState = new class_7094();
    public final class_7094 diggingAnimationState = new class_7094();
    @Nullable
    private class_2338 burrowPos;

    public Mole(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_STATE, (Object)State.IDLING);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23721, 8.0);
    }

    public class_4095<Mole> method_18868() {
        return super.method_18868();
    }

    protected class_4095.class_5303<Mole> method_28306() {
        return MoleAi.brainProvider();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return MoleAi.makeBrain((class_4095<Mole>)this.method_28306().method_28335(dynamic));
    }

    protected void method_5958() {
        class_3695 profiler = this.method_37908().method_16107();
        profiler.method_15396("moleBrain");
        class_4095<Mole> brain = this.method_18868();
        brain.method_19542((class_3218)this.method_37908(), (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("moleActivityUpdate");
        MoleAi.updateActivity(this);
        profiler.method_15407();
        super.method_5958();
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setBurrowPos(class_2512.method_10691((class_2487)compoundTag, (String)"BurrowPos").orElse(null));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.getBurrowPos() != null) {
            compoundTag.method_10566("BurrowPos", class_2512.method_10692((class_2338)this.getBurrowPos()));
        }
    }

    public boolean method_5810() {
        return !this.cannotMove() && super.method_5810();
    }

    public void method_5711(byte b) {
        if (b == 4) {
            for (int i = 0; i < 5; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(b);
        }
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(GItemTags.MOLE_FOOD);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)GEntityTypes.MOLE.method_5883((class_1937)serverLevel);
    }

    public Mole transitionTo(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 1: {
                this.setState(State.TWITCHING).onTwitchingStart();
                break;
            }
            case 2: {
                this.setState(State.EMERGE).onEmergingStart();
                break;
            }
            case 3: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case 4: {
                this.setState(State.SNIFFING);
            }
        }
        return this;
    }

    public void onTwitchingStart() {
        this.method_5783(class_3417.field_18063, 1.0f, 1.0f);
    }

    public void onEmergingStart() {
        this.method_5783(class_3417.field_14770, 1.0f, 1.0f);
    }

    public void onDiggingStart() {
    }

    public static boolean isValidTargetState(class_1937 level, class_2338 blockPos, class_1309 livingEntity) {
        MoleBurrowBlockEntity moleBurrowBlock;
        class_2586 class_25862;
        if (!(livingEntity instanceof Mole)) {
            return false;
        }
        Mole mole = (Mole)livingEntity;
        return mole.getBurrowPos() == null && (class_25862 = level.method_8321(blockPos)) instanceof MoleBurrowBlockEntity && (moleBurrowBlock = (MoleBurrowBlockEntity)class_25862).isEmpty();
    }

    public static boolean isTuffDirt(class_1937 level, class_2338 blockPos, class_1309 livingEntity) {
        class_2680 state = level.method_8320(blockPos.method_10084());
        return state.method_26227().method_15769() && state.method_45474() && level.method_8320(blockPos).method_27852(GBlocks.TUFF_DIRT);
    }

    protected void method_48565(float f) {
        float change = this.method_6109() ? 0.3f : 1.0f;
        float g = Math.min(f * 25.0f, 1.0f) * change;
        this.field_42108.method_48568(g, 0.4f);
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(DATA_STATE));
    }

    private Mole setState(State state) {
        this.field_6011.method_12778(DATA_STATE, (Object)state);
        return this;
    }

    @Nullable
    public class_2338 getBurrowPos() {
        return this.burrowPos;
    }

    public void setBurrowPos(class_2338 blockPos) {
        this.burrowPos = blockPos;
    }

    public Optional<class_2338> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(i -> class_5534.method_31527((class_1314)this, (int)4, (int)2)).filter(Objects::nonNull).map(class_2338::method_49638).filter(blockPos -> this.method_37908().method_8621().method_11952(blockPos)).map(class_2338::method_10074).filter(this::canDig).findFirst();
    }

    public void method_5773() {
        super.method_5773();
        if (this.getState() == State.DIGGING) {
            long animationTime = this.diggingAnimationState.method_43687();
            class_2338 blockPos = this.method_24515();
            class_2680 blockState = this.method_37908().method_8320(blockPos.method_10074());
            if (animationTime > 1000L && blockState.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 30; ++i) {
                    class_243 vec3 = class_243.method_24953((class_2382)blockPos).method_1031(0.0, (double)-0.65f, 0.0);
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), vec3.field_1352, vec3.field_1351, vec3.field_1350, 0.0, 0.0, 0.0);
                }
                if (this.field_6012 % 2 == 0) {
                    float pitch = this.method_6109() ? 0.7f : 0.5f;
                    this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), blockState.method_26231().method_10596(), this.method_5634(), 0.5f, pitch, false);
                }
            }
        }
    }

    public boolean isTempted() {
        return this.field_18321.method_18904(class_4140.field_28327).orElse(false);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (DATA_STATE.equals(entityDataAccessor)) {
            State state = this.getState();
            this.resetAnimations();
            switch (state.ordinal()) {
                case 1: {
                    this.twitchAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 2: {
                    this.emergeAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 3: {
                    this.diggingAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 4: {
                    this.sniffAnimationState.method_41324(this.field_6012);
                }
            }
        }
        super.method_5674(entityDataAccessor);
    }

    private void resetAnimations() {
        this.twitchAnimationState.method_41325();
        this.diggingAnimationState.method_41325();
        this.emergeAnimationState.method_41325();
        this.sniffAnimationState.method_41325();
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.method_6109() && !this.method_52546() && !this.method_5799() && !this.method_6479() && !this.method_5765() && !this.method_60953();
    }

    public boolean canDig() {
        class_2680 belowState = this.method_37908().method_8320(this.method_24515().method_10074());
        return belowState.method_26164(GBlockTags.MOLE_DIGGABLE_BLOCK) && !this.method_52546() && !this.isTempted() && !this.method_6109() && !this.method_60953() && !this.method_5799() && this.method_24828() && !this.method_5765() && this.method_18868().method_18904(class_4140.field_22474).isEmpty();
    }

    private boolean canDig(class_2338 blockPos) {
        return this.method_37908().method_8320(blockPos).method_26164(GBlockTags.MOLE_DIGGABLE_BLOCK) && Optional.ofNullable(this.method_5942().method_6348(blockPos, 1)).map(class_11::method_21655).orElse(false) != false;
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData) {
        if (mobSpawnType == class_3730.field_16461) {
            this.setBurrowPos(this.method_24515().method_10074());
            this.transitionTo(State.EMERGE);
            this.method_18868().method_24525(class_4140.field_38112, (Object)class_3902.field_17274, 40L);
            this.method_18868().method_24525(class_4140.field_38105, (Object)class_3902.field_17274, 200L);
        }
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    public void method_6091(class_243 vec3) {
        if (this.cannotMove() && this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            vec3 = vec3.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(vec3);
    }

    @Nullable
    protected class_3414 method_5994() {
        return MoleAi.getSoundForActivity(this);
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_31573(GItemTags.MOLE_FAVORITES)) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_40076, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
            this.method_18868().method_24525(GMemoryModuleTypes.MOLE_HOMING, (Object)class_3902.field_17274, 6000L);
            itemStack.method_57008(1, (class_1309)player);
            return class_1269.field_5812;
        }
        return super.method_5992(player, interactionHand);
    }

    private boolean cannotMove() {
        State state = this.getState();
        return state == State.EMERGE || state == State.DIGGING;
    }

    public static enum State {
        IDLING(0),
        TWITCHING(1),
        EMERGE(2),
        DIGGING(3),
        SNIFFING(4);

        public static final IntFunction<State> BY_ID;
        public static final class_9139<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int j) {
            this.id = j;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = class_7995.method_47914(State::id, (Object[])State.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, State::id);
        }
    }
}

