/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.orcinus.galosphere.crafting.WeaponRackingLoader;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.util.weapon_racks.WeaponRackSetting;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponRack
extends class_1530 {
    private static final class_2940<class_1799> DATA_ITEM = class_2945.method_12791(WeaponRack.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> DATA_ROTATION = class_2945.method_12791(WeaponRack.class, (class_2941)class_2943.field_13327);
    private float dropChance = 1.0f;
    private boolean fixed = false;

    public WeaponRack(class_1299<? extends WeaponRack> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5648(false);
    }

    public WeaponRack(class_1937 level, class_2338 blockPos, class_2350 direction) {
        this(GEntityTypes.WEAPON_RACK, level, blockPos, direction);
    }

    public WeaponRack(class_1299<? extends WeaponRack> entityType, class_1937 level, class_2338 blockPos, class_2350 direction) {
        super(entityType, level, blockPos);
        this.method_6892(direction);
        this.method_5648(false);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_ITEM, (Object)class_1799.field_8037);
        builder.method_56912(DATA_ROTATION, (Object)0);
    }

    protected void method_6892(class_2350 direction) {
        Validate.notNull((Object)direction);
        this.field_7099 = direction;
        if (direction.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * direction.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return new class_2604((class_1297)this, this.field_7099.method_10146(), this.method_59940());
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
        this.method_6892(class_2350.method_10143((int)clientboundAddEntityPacket.method_11166()));
    }

    public float method_43078() {
        class_2350 direction = this.method_5735();
        int i = direction.method_10166().method_10178() ? 90 * direction.method_10171().method_10181() : 0;
        return class_3532.method_15392((int)(180 + direction.method_10161() * 90 + this.getRotation() * 45 + i));
    }

    protected class_238 method_59943(class_2338 blockPos, class_2350 direction) {
        class_243 vec3 = class_243.method_24953((class_2382)blockPos).method_43206(direction, -0.46875);
        class_2350.class_2351 axis = direction.method_10166();
        double d = axis == class_2350.class_2351.field_11048 ? 0.0625 : 0.75;
        double e = axis == class_2350.class_2351.field_11052 ? 0.0625 : 0.75;
        double g = axis == class_2350.class_2351.field_11051 ? 0.0625 : 0.75;
        return class_238.method_30048((class_243)vec3, (double)d, (double)e, (double)g);
    }

    public boolean method_6888() {
        if (this.fixed) {
            return true;
        }
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2680 blockState = this.method_37908().method_8320(this.field_51589.method_10093(this.field_7099.method_10153()));
        return blockState.method_51367() || this.field_7099.method_10166().method_10179() && class_2312.method_9999((class_2680)blockState) ? this.method_37908().method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty() : false;
    }

    public void method_5784(class_1313 moverType, class_243 vec3) {
        if (!this.fixed) {
            super.method_5784(moverType, vec3);
        }
    }

    public void method_5762(double d, double e, double f) {
        if (!this.fixed) {
            super.method_5762(d, e, f);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.fixed) {
            if (this.method_5679(source)) {
                return false;
            }
            if (!source.method_48789(class_8103.field_42249) && !this.getItem().method_7960()) {
                if (!this.method_37908().field_9236) {
                    this.dropItem(source.method_5529(), false);
                    this.method_32875((class_6880)class_5712.field_28733, source.method_5529());
                    this.method_5783(this.getRemoveItemSound(), 1.0f, 1.0f);
                }
                return true;
            }
            return super.method_5643(source, amount);
        }
        return (source.method_48789(class_8103.field_42242) || source.method_5530()) && super.method_5643(source, amount);
    }

    public void method_6894() {
        this.method_5783(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public boolean method_5640(double d) {
        double e = 16.0;
        return d < (e *= 64.0 * WeaponRack.method_5824()) * e;
    }

    public void method_6889(@Nullable class_1297 entity) {
        this.method_5783(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(entity, true);
        this.method_32875((class_6880)class_5712.field_28733, entity);
    }

    private void dropItem(@Nullable class_1297 entity, boolean bl) {
        if (!this.fixed) {
            class_1799 itemStack = this.getItem();
            this.setItem(class_1799.field_8037);
            if (!this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                return;
            }
            if (bl) {
                this.method_5775(this.getFrameItemStack());
            }
            if (!itemStack.method_7960()) {
                itemStack = itemStack.method_7972();
                if (this.field_5974.method_43057() < this.dropChance) {
                    this.method_5775(itemStack);
                }
            }
        }
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        class_1799 itemStack = this.getItem();
        if (!itemStack.method_7960()) {
            compoundTag.method_10566("Item", this.getItem().method_57358((class_7225.class_7874)this.method_56673()));
        }
        compoundTag.method_10567("ItemRotation", (byte)this.getRotation());
        compoundTag.method_10548("ItemDropChance", this.dropChance);
        compoundTag.method_10567("Facing", (byte)this.field_7099.method_10146());
    }

    public void method_5749(class_2487 compoundTag) {
        class_1799 itemStack;
        super.method_5749(compoundTag);
        if (compoundTag.method_10573("Item", 10)) {
            class_2487 compoundTag2 = compoundTag.method_10562("Item");
            itemStack = class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag2).orElse(class_1799.field_8037);
        } else {
            itemStack = class_1799.field_8037;
        }
        this.setItem(itemStack, false);
        this.setRotation(compoundTag.method_10571("ItemRotation"), false);
        if (compoundTag.method_10573("ItemDropChance", 99)) {
            this.dropChance = compoundTag.method_10583("ItemDropChance");
        }
        this.method_6892(class_2350.method_10143((int)compoundTag.method_10571("Facing")));
    }

    public void setItem(class_1799 itemStack) {
        this.setItem(itemStack, true);
    }

    public void setItem(class_1799 itemStack, boolean bl) {
        if (!itemStack.method_7960()) {
            itemStack = itemStack.method_46651(1);
        }
        this.onItemChanged(itemStack);
        this.method_5841().method_12778(DATA_ITEM, (Object)itemStack);
        if (!itemStack.method_7960()) {
            this.method_5783(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (bl) {
            this.method_37908().method_8455(this.field_51589, class_2246.field_10124);
        }
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (entityDataAccessor.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(class_1799 itemStack) {
        if (!itemStack.method_7960() && itemStack.method_27319() instanceof WeaponRack) {
            itemStack.method_27320((class_1297)this);
        }
        this.method_6895();
    }

    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (this.fixed) {
            return class_1269.field_5811;
        }
        if (!player.method_37908().field_9236) {
            boolean flag;
            boolean empty = this.getItem().method_7960();
            boolean hasItem = !itemStack.method_7960() && itemStack.method_31573(GItemTags.WEAPON_RACKS_CAN_HOLD);
            boolean bl = flag = empty && hasItem && !this.method_31481();
            if (flag) {
                this.setItem(itemStack);
                this.method_32875((class_6880)class_5712.field_28733, (class_1297)player);
                itemStack.method_57008(1, (class_1309)player);
            } else {
                this.method_5783(this.getRotateItemSound(), 1.0f, 1.0f);
                this.setRotation(this.getRotation() + 1);
                this.method_32875((class_6880)class_5712.field_28733, (class_1297)player);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    @Nullable
    public class_1799 method_31480() {
        class_1799 itemStack = this.getItem();
        return itemStack.method_7960() ? this.getFrameItemStack() : itemStack.method_7972();
    }

    protected class_1799 getFrameItemStack() {
        return new class_1799((class_1935)GItems.WEAPON_RACK);
    }

    public int getRotation() {
        return (Integer)this.method_5841().method_12789(DATA_ROTATION);
    }

    public void setRotation(int i) {
        this.setRotation(i, true);
    }

    private void setRotation(int i, boolean bl) {
        this.method_5841().method_12778(DATA_ROTATION, (Object)(i % 8));
        if (bl) {
            this.method_37908().method_8455(this.field_51589, class_2246.field_10124);
        }
    }

    public class_3414 getBreakSound() {
        return GSoundEvents.PALLADIUM.method_10595();
    }

    public class_3414 getPlaceSound() {
        return GSoundEvents.PALLADIUM.method_10598();
    }

    public class_3414 getAddItemSound() {
        return class_3417.field_14667;
    }

    public class_1799 getItem() {
        return (class_1799)this.method_5841().method_12789(DATA_ITEM);
    }

    public class_3414 getRemoveItemSound() {
        return class_3417.field_14770;
    }

    public class_3414 getRotateItemSound() {
        return class_3417.field_15038;
    }

    private WeaponRackSetting setting() {
        return this.settingsList(this::matchesItem).getFirst();
    }

    private boolean matchesItem(WeaponRackSetting weaponRackSetting) {
        return weaponRackSetting.ingredient().method_8093(this.getItem());
    }

    @NotNull
    private List<WeaponRackSetting> settingsList(Predicate<WeaponRackSetting> predicate) {
        return WeaponRackingLoader.SETTINGS.stream().filter(predicate).toList();
    }

    public boolean isInvalidShift(float value) {
        return value == -11.0f;
    }

    public boolean isInvalidRotation(float value) {
        return value == -190.0f;
    }

    public float getXShift() {
        boolean empty;
        class_1799 itemStack = this.getItem();
        boolean ranged = itemStack.method_31573(ConventionalItemTags.RANGED_WEAPON_TOOLS) && !itemStack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
        boolean nonTools = itemStack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS) || ranged || itemStack.method_31573(ConventionalItemTags.BRUSH_TOOLS);
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidShift(this.setting().xShift());
        if (empty) {
            return nonTools ? 0.5525f : 0.5325f;
        }
        return this.setting().xShift();
    }

    public float getYShift() {
        boolean empty;
        class_1799 itemStack = this.getItem();
        boolean ranged = itemStack.method_31573(ConventionalItemTags.RANGED_WEAPON_TOOLS) && !itemStack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidShift(this.setting().yShift());
        if (empty) {
            return ranged ? -0.015f : -0.4375f;
        }
        return this.setting().yShift();
    }

    public float getZShift() {
        boolean empty;
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidShift(this.setting().zShift());
        if (empty) {
            return 0.02575f;
        }
        return this.setting().zShift();
    }

    public float getPitchRotation() {
        boolean empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidRotation(this.setting().pitch());
        return empty ? 0.0f : this.setting().pitch();
    }

    public float getYawRotation() {
        boolean empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidRotation(this.setting().yaw());
        return empty ? 0.0f : this.setting().yaw();
    }

    public float getRollRotation() {
        boolean empty;
        class_1799 itemStack = this.getItem();
        boolean ranged = itemStack.method_31573(ConventionalItemTags.RANGED_WEAPON_TOOLS) && !itemStack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidRotation(this.setting().roll());
        if (empty) {
            return ranged ? 45.0f : 135.0f;
        }
        return this.setting().roll();
    }
}

