/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4121;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4802;
import net.minecraft.class_4806;
import net.minecraft.class_4813;
import net.minecraft.class_4814;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7687;
import net.minecraft.class_7893;
import net.minecraft.class_7895;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.entities.ai.tasks.mole.AssignBurrow;
import net.orcinus.galosphere.entities.ai.tasks.mole.CreateBurrow;
import net.orcinus.galosphere.entities.ai.tasks.mole.DigUp;
import net.orcinus.galosphere.entities.ai.tasks.mole.FinishedRummaging;
import net.orcinus.galosphere.entities.ai.tasks.mole.MoleSearching;
import net.orcinus.galosphere.entities.ai.tasks.mole.MoleSniffing;
import net.orcinus.galosphere.entities.ai.tasks.mole.ReturnBurrow;
import net.orcinus.galosphere.entities.ai.tasks.mole.Rummaging;
import net.orcinus.galosphere.entities.ai.tasks.mole.Twitching;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import org.jetbrains.annotations.Nullable;

public class MoleAi {
    private static final class_6019 ADULT_FOLLOW_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final ImmutableList<class_4149<? extends class_4148<? super Mole>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, (Object)class_4149.field_25362, GSensorTypes.MOLE_TEMPTATIONS, GSensorTypes.NEAREST_MOLE_BURROW, GSensorTypes.NEAREST_TUFF_DIRT, GSensorTypes.MOLE_REPELLENTS, GSensorTypes.MOLE_ENTITY_SENSOR);
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_39408, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_18446, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_28327, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_25359, class_4140.field_38105, class_4140.field_38112, class_4140.field_22355, class_4140.field_22475, class_4140.field_22474, class_4140.field_30243, class_4140.field_22357, GMemoryModuleTypes.MOLE_DIGGING, GMemoryModuleTypes.MOLE_RETURNING, GMemoryModuleTypes.MOLE_DIGGING_TARGET, GMemoryModuleTypes.NEAREST_MOLE_BURROW, GMemoryModuleTypes.MOLE_HOMING, GMemoryModuleTypes.NEAREST_TUFF_DIRT});
    public static final class_6019 AVOID_DURATION = class_4802.method_24505((int)5, (int)7);

    public static class_4095.class_5303<Mole> brainProvider() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static class_4095<?> makeBrain(class_4095<Mole> brain) {
        MoleAi.initCoreActivity(brain);
        MoleAi.initIdleActivity(brain);
        MoleAi.initAvoidActivity(brain);
        MoleAi.initFightActivity(brain);
        MoleAi.initEmergeActivity(brain);
        MoleAi.initSniffingActivity(brain);
        MoleAi.initDiggingActivity(brain);
        MoleAi.initBurrowCreatingActivity(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(class_4095<Mole> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_6028(2.0f), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)((Object)new AssignBurrow()), (Object)new class_5753(class_4140.field_28326)));
    }

    private static void initIdleActivity(class_4095<Mole> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, MoleAi.avoidRepellent()), (Object)Pair.of((Object)1, (Object)class_4824.method_47119(mole -> mole.method_18868().method_18904(class_4140.field_30243))), (Object)Pair.of((Object)2, (Object)class_7895.method_47069((class_1299)class_1299.field_6097, (float)6.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new class_4806(GEntityTypes.MOLE)), (Object)Pair.of((Object)4, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)new class_5754(livingEntity -> Float.valueOf(1.25f), livingEntity -> livingEntity.method_6109() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)1.25f), (Object)1)))), (Object)Pair.of((Object)5, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)6, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new ReturnBurrow()), (Object)1), (Object)Pair.of((Object)((Object)new Twitching()), (Object)1), (Object)Pair.of((Object)((Object)new MoleSniffing()), (Object)1), (Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))), Set.of(Pair.of(GMemoryModuleTypes.MOLE_DIGGING, (Object)class_4141.field_18457), Pair.of(GMemoryModuleTypes.MOLE_DIGGING_TARGET, (Object)class_4141.field_18457)));
    }

    private static void initEmergeActivity(class_4095<Mole> brain) {
        brain.method_24527(class_4168.field_38202, 5, ImmutableList.of((Object)((Object)new DigUp())), class_4140.field_38112);
    }

    private static void initSniffingActivity(class_4095<Mole> brain) {
        brain.method_24529(class_4168.field_38199, ImmutableList.of((Object)Pair.of((Object)0, MoleAi.avoidRepellent()), (Object)Pair.of((Object)1, (Object)((Object)new MoleSearching()))), Set.of(Pair.of(GMemoryModuleTypes.MOLE_HOMING, (Object)class_4141.field_18457), Pair.of(GMemoryModuleTypes.MOLE_DIGGING, (Object)class_4141.field_18457), Pair.of(GMemoryModuleTypes.MOLE_RETURNING, (Object)class_4141.field_18457), Pair.of(GMemoryModuleTypes.MOLE_DIGGING_TARGET, (Object)class_4141.field_18456)));
    }

    private static void initDiggingActivity(class_4095<Mole> brain) {
        brain.method_24529(class_4168.field_38203, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Rummaging())), (Object)Pair.of((Object)1, (Object)((Object)new FinishedRummaging()))), Set.of(Pair.of(GMemoryModuleTypes.MOLE_HOMING, (Object)class_4141.field_18457), Pair.of(GMemoryModuleTypes.MOLE_RETURNING, (Object)class_4141.field_18457), Pair.of(GMemoryModuleTypes.MOLE_DIGGING, (Object)class_4141.field_18456), Pair.of(GMemoryModuleTypes.MOLE_DIGGING_TARGET, (Object)class_4141.field_18457)));
    }

    private static void initFightActivity(class_4095<Mole> brain) {
        brain.method_24527(class_4168.field_22396, 0, ImmutableList.of((Object)class_4828.method_47132(), (Object)class_4822.method_47094((float)1.5f), (Object)class_4816.method_46987((int)20), (Object)class_4813.method_46922(class_4215::method_41331, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static void initBurrowCreatingActivity(class_4095<Mole> brain) {
        brain.method_24527(class_4168.field_19043, 5, ImmutableList.of(MoleAi.avoidRepellent(), (Object)class_4814.method_46941(GMemoryModuleTypes.NEAREST_TUFF_DIRT, (int)1, (float)1.0f), (Object)((Object)new CreateBurrow()), (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new Twitching()), (Object)1), (Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)))), GMemoryModuleTypes.MOLE_HOMING);
    }

    private static void initAvoidActivity(class_4095<Mole> brain) {
        brain.method_24527(class_4168.field_22399, 5, ImmutableList.of((Object)class_4121.method_24603((class_4140)class_4140.field_22357, (float)1.75f, (int)15, (boolean)false), (Object)class_4813.method_46922(mole -> !mole.method_18868().method_18896(class_4140.field_22357), (class_4140)class_4140.field_22357)), class_4140.field_22357);
    }

    public static class_3414 getSoundForActivity(Mole mole) {
        Optional activity = mole.method_18868().method_24538();
        return activity.isPresent() && activity.get() == class_4168.field_22399 ? class_3417.field_18265 : class_3417.field_18056;
    }

    private static class_7893<class_1314> avoidRepellent() {
        return class_4121.method_47091((class_4140)class_4140.field_22474, (float)1.5f, (int)8, (boolean)false);
    }

    public static void updateActivity(Mole mole) {
        mole.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_19043, (Object)class_4168.field_38203, (Object)class_4168.field_38199, (Object)class_4168.field_22396, (Object)class_4168.field_38202, (Object)class_4168.field_22399, (Object)class_4168.field_18595));
    }

    public static Predicate<class_1799> getTemptations() {
        return itemStack -> itemStack.method_31573(GItemTags.MOLE_FOOD) || itemStack.method_31573(GItemTags.MOLE_FAVORITES);
    }

    public static boolean validRepellent(class_3218 serverLevel, @Nullable class_2338 blockPos, @Nullable class_1309 target) {
        if (blockPos != null) {
            return serverLevel.method_8320(blockPos).method_26164(GBlockTags.MOLE_REPELLENTS);
        }
        if (target != null) {
            return target.method_6047().method_31573(GItemTags.MOLE_REPELLENTS) || target.method_6079().method_31573(GItemTags.MOLE_REPELLENTS);
        }
        return false;
    }
}

