/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.ClientboundBoostPlayerPacket;
import net.orcinus.galosphere.network.PlayCooldownSoundPacket;
import net.orcinus.galosphere.network.SendOpalParticlePacket;
import net.orcinus.galosphere.network.SendParticlesPacket;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import net.orcinus.galosphere.network.SpelunkingEffectPacket;

@Environment(value=EnvType.CLIENT)
public class GClientNetwork {
    public static void receiveParticles(SendParticlesPacket packet, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        class_2338 blockPos = packet.blockPos();
        client.execute(() -> {
            class_638 world = client.field_1687;
            if (world == null) {
                return;
            }
            class_5819 random = world.method_8409();
            world.method_45446(blockPos, GSoundEvents.GLOW_FLARE_SPREAD, class_3419.field_15245, 1.0f, 1.0f, false);
            boolean flag = world.method_8320(blockPos).method_26234((class_1922)world, blockPos);
            int l2 = flag ? 40 : 20;
            float f9 = flag ? 0.45f : 0.25f;
            for (int k3 = 0; k3 < l2; ++k3) {
                float f12 = 2.0f * random.method_43057() - 1.0f;
                float f14 = 2.0f * random.method_43057() - 1.0f;
                float f15 = 2.0f * random.method_43057() - 1.0f;
                world.method_8406((class_2394)class_2398.field_28479, (double)blockPos.method_10263() + 0.5 + (double)(f12 * f9), (double)blockPos.method_10264() + 0.5 + (double)(f14 * f9), (double)blockPos.method_10260() + 0.5 + (double)(f15 * f9), (double)(f12 * 0.07f), (double)(f14 * 0.07f), (double)(f15 * 0.07f));
            }
            world.method_45446(blockPos, GSoundEvents.GLOW_FLARE_SPREAD, class_3419.field_15245, 1.0f, 1.0f, false);
        });
    }

    public static void receivePerspective(SendPerspectivePacket packet, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        UUID uuid = packet.uuid();
        int id = packet.id();
        client.execute(() -> {
            class_638 world = client.field_1687;
            if (world != null) {
                Optional.ofNullable(world.method_18470(uuid)).filter(player -> player.equals((Object)client.field_1724)).flatMap(player -> Optional.ofNullable(client.field_1687.method_8469(id))).ifPresent(entity -> {
                    client.method_1504(entity);
                    if (!client.field_1690.method_31044().method_31034()) {
                        client.field_1690.method_31043(class_5498.field_26664);
                    }
                });
            }
        });
    }

    public static void receiveCooldownSound(PlayCooldownSoundPacket packet, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            if (client.field_1724 != null) {
                client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)GSoundEvents.SALTBOUND_TABLET_COOLDOWN_OVER, (float)1.0f));
            }
        });
    }

    public static void receiveSpelunkingEffect(SpelunkingEffectPacket packet, ClientPlayNetworking.Context context) {
        class_310 client = class_310.method_1551();
        class_2338 blockPos = packet.blockPos();
        int range = packet.range();
        int amount = packet.amount();
        client.execute(() -> {
            class_638 level = client.field_1687;
            if (level == null) {
                return;
            }
            class_5819 random = level.field_9229;
            level.method_8486((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, class_3417.field_43154, class_3419.field_15245, 0.5f + random.method_43057(), random.method_43057() * 0.7f + 0.6f, false);
            for (int i = 0; i < amount; ++i) {
                class_2338 pos2 = blockPos.method_10069(class_3532.method_32751((class_5819)random, (int)(-range), (int)range), class_3532.method_32751((class_5819)random, (int)(-range), (int)range), class_3532.method_32751((class_5819)random, (int)(-range), (int)range));
                if (level.method_8320(pos2).method_26234((class_1922)level, pos2)) {
                    return;
                }
                float xs = (float)(blockPos.method_10263() - pos2.method_10263()) * 0.06f;
                float ys = (float)(blockPos.method_10264() - pos2.method_10264()) * 0.06f;
                float zs = (float)(blockPos.method_10260() - pos2.method_10260()) * 0.06f;
                level.method_8406((class_2394)GParticleTypes.ALLURITE_RAIN, (double)pos2.method_10263() + random.method_43058(), (double)pos2.method_10264() + random.method_43058(), (double)pos2.method_10260() + random.method_43058(), (double)xs, (double)ys, (double)zs);
            }
        });
    }

    public static void receivePlayerBoost(ClientboundBoostPlayerPacket packet, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            class_746 player = client.field_1724;
            if (player != null) {
                player.method_18799(player.method_18798().method_1021(packet.power()).method_1019(player.method_5720().method_1021(0.3)));
            }
        });
    }

    public static void receiveOpalParticle(SendOpalParticlePacket packet, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        class_2338 blockPos = packet.blockPos();
        client.execute(() -> {
            class_638 world = client.field_1687;
            if (world == null) {
                return;
            }
            class_2248 patt0$temp = world.method_8320(blockPos).method_26204();
            if (patt0$temp instanceof class_2256) {
                class_2256 bonemealableBlock = (class_2256)patt0$temp;
                class_2338 blockPos2 = bonemealableBlock.method_55769(blockPos);
                class_5945.method_55636((class_1936)world, (class_2338)blockPos2, (int)15, (class_2394)GParticleTypes.OPAL_GLINT);
                world.method_45446(blockPos, class_3417.field_33433, class_3419.field_15245, 1.0f, 1.0f, false);
            }
        });
    }

    public static void clientInit() {
        ClientPlayNetworking.registerGlobalReceiver(SendParticlesPacket.TYPE, GClientNetwork::receiveParticles);
        ClientPlayNetworking.registerGlobalReceiver(SendPerspectivePacket.TYPE, GClientNetwork::receivePerspective);
        ClientPlayNetworking.registerGlobalReceiver(PlayCooldownSoundPacket.TYPE, GClientNetwork::receiveCooldownSound);
        ClientPlayNetworking.registerGlobalReceiver(SpelunkingEffectPacket.TYPE, GClientNetwork::receiveSpelunkingEffect);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundBoostPlayerPacket.TYPE, GClientNetwork::receivePlayerBoost);
        ClientPlayNetworking.registerGlobalReceiver(SendOpalParticlePacket.TYPE, GClientNetwork::receiveOpalParticle);
    }
}

