/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.items.components.MonstrometerTracker;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class MonstrometerItem
extends class_1792 {
    private static final int MAX_FUEL = 4;
    private static final int MAX_USE_TIME = 52;
    private static final int DECREMENT_USE_TIME_INTERVAL = 30;
    private static final int LUMIERE_FUEL_BAR_COLOR = 16757273;
    public static final class_2561 INSERT_FUEL = class_2561.method_43471((String)"item.galosphere.monstrometer.description");

    public MonstrometerItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Nullable
    private static MonstrometerTracker getMonstrometerTracker(class_1799 stack) {
        return (MonstrometerTracker)stack.method_57824(GDataComponents.MONSTROMETER_TRACKER);
    }

    public static List<class_2338> getIndicatedBlocks(class_2338 pos, Predicate<class_2338> predicate) {
        int radius = 20;
        int height = 6;
        ArrayList list = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    if (x * x + z * z > radius * radius) continue;
                    list.add(pos.method_10069(x, y, z));
                }
            }
        }
        return list.stream().filter(predicate).toList();
    }

    public static List<class_1309> getNearbyMonsters(class_1937 level, class_2338 pos) {
        return level.method_8390(class_1309.class, new class_238(pos).method_1009(16.0, 6.0, 16.0), livingEntity -> livingEntity.method_5805() && livingEntity instanceof class_1588);
    }

    public static boolean isUnsafe(class_1937 level, class_2338 pos) {
        return level.method_8314(class_1944.field_9282, pos) <= level.method_8597().method_44223();
    }

    public int method_31571(class_1799 stack) {
        return 16757273;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int i, boolean bl) {
        if (this.isActive(stack) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
            if (level.method_8510() % 30L == 0L) {
                Predicate<class_2338> predicate = pos -> level.method_22347(pos) && level.method_8320(pos.method_10074()).method_26216((class_1922)level, pos.method_10074()) && class_1948.method_8662((class_1922)level, (class_2338)pos, (class_2680)level.method_8320(pos), (class_3610)level.method_8316(pos), (class_1299)class_1299.field_6051);
                MonstrometerItem.getIndicatedBlocks(entity.method_24515(), predicate).forEach(pos -> {
                    double x = (double)pos.method_10263() + 0.5;
                    double y = (float)pos.method_10264() + 0.01f;
                    double z = (double)pos.method_10260() + 0.5;
                    serverLevel.method_14199((class_2394)GParticleTypes.MONSTROMETER_INDICATOR, x, y, z, 1, 0.0, 0.0, 0.0, 0.5);
                });
                MonstrometerItem.getNearbyMonsters(level, entity.method_24515()).forEach(mob -> mob.method_6092(new class_1293(class_1294.field_5912, 60)));
                int decremented = tracker.useTime() - 1;
                if (decremented == 0) {
                    level.method_45445(entity, entity.method_24515(), GSoundEvents.MONSTROMETER_DEACTIVATE, entity.method_5634(), 1.0f, 1.0f);
                }
                stack.method_57379(GDataComponents.MONSTROMETER_TRACKER, (Object)MonstrometerTracker.of(decremented == 0 ? tracker.fuel() - 1 : tracker.fuel(), decremented));
            }
        }
    }

    public int method_31569(class_1799 stack) {
        return MonstrometerItem.getFuelBarWidth(stack);
    }

    private boolean isActive(class_1799 stack) {
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        return tracker != null && tracker.useTime() > 0;
    }

    private static int getFuelBarWidth(class_1799 stack) {
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        return tracker == null ? 0 : class_3532.method_15340((int)class_3532.method_59515((Fraction)Fraction.getFraction((int)tracker.fuel(), (int)4), (int)13), (int)0, (int)13);
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        int fuel;
        if (action != class_5536.field_27013 || !slot.method_32754(player)) {
            return false;
        }
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        int n = fuel = tracker != null ? tracker.fuel() : 0;
        if (other.method_31573(GItemTags.MONSTROMETER_FUEL) && fuel < 4) {
            int shrinkAmount = other.method_7947();
            int combinedFuel = fuel + other.method_7947();
            if (combinedFuel > 4) {
                shrinkAmount -= combinedFuel - 4;
            }
            other.method_7934(shrinkAmount);
            stack.method_57379(GDataComponents.MONSTROMETER_TRACKER, (Object)MonstrometerTracker.updateFuel(tracker, Math.min(4, combinedFuel)));
            player.method_5783(GSoundEvents.MONSTROMETER_CHARGE, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        MonstrometerTracker tracker = MonstrometerItem.getMonstrometerTracker(stack);
        if (tracker != null && tracker.fuel() > 0 && !this.isActive(stack)) {
            stack.method_57379(GDataComponents.MONSTROMETER_TRACKER, (Object)MonstrometerTracker.updateUseTime(tracker, 52));
            player.method_7357().method_7906((class_1792)this, 1560);
            player.method_5783(GSoundEvents.MONSTROMETER_ACTIVATE, 1.0f, 1.0f);
            return class_1271.method_22427((Object)stack);
        }
        return super.method_7836(level, player, hand);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 tooltipFlag) {
        list.add((class_2561)INSERT_FUEL.method_27661().method_27692(class_124.field_1080));
    }
}

