/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.trunks;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.orcinus.galosphere.init.GTrunkPlacers;

public class OpalTrunkPlacer
extends class_5141 {
    public static final MapCodec<OpalTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.field_23760), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(trunkPlacer -> trunkPlacer.field_23761), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(trunkPlacer -> trunkPlacer.field_23762), (App)class_6017.method_35004((int)0, (int)4).fieldOf("branch_length").forGetter(trunkPlacer -> trunkPlacer.branchLength)).apply((Applicative)instance, OpalTrunkPlacer::new));
    private final class_6017 branchLength;

    public OpalTrunkPlacer(int i, int j, int k, class_6017 branchLength) {
        super(i, j, k);
        this.branchLength = branchLength;
    }

    protected class_5142<?> method_28903() {
        return GTrunkPlacers.OPAL_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 levelSimulatedReader, BiConsumer<class_2338, class_2680> biConsumer, class_5819 randomSource, int height, class_2338 blockPos, class_4643 treeConfiguration) {
        ArrayList foliageAttachments = Lists.newArrayList();
        int branchLength = this.branchLength.method_35008(randomSource);
        for (class_2350 branchingDirection : class_2350.class_2353.field_11062) {
            if (!(randomSource.method_43057() < 0.6f)) continue;
            int maxLength = class_6019.method_35017((int)1, (int)2).method_35008(randomSource);
            for (int length = 0; length <= maxLength; ++length) {
                this.method_35375(levelSimulatedReader, biConsumer, randomSource, blockPos.method_10093(branchingDirection).method_10086(length), treeConfiguration);
            }
        }
        for (int i = 0; i <= height; ++i) {
            class_2338 logPos = blockPos.method_10086(i);
            if (i == height - 2) {
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    for (int length = 0; length <= branchLength; ++length) {
                        class_2338 branchPos = logPos.method_10079(direction, length);
                        Function<class_2680, class_2680> function = blockState -> (class_2680)blockState.method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166());
                        this.method_27402(levelSimulatedReader, biConsumer, randomSource, branchPos, treeConfiguration, function);
                        if (length != branchLength) continue;
                        this.method_35375(levelSimulatedReader, biConsumer, randomSource, branchPos.method_10084(), treeConfiguration);
                    }
                }
            }
            if (i == height) {
                int secondBranchLength = branchLength * 2;
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    for (int length = 0; length <= secondBranchLength; ++length) {
                        class_2338 branchPos = logPos.method_10079(direction, length);
                        Function<class_2680, class_2680> function = blockState -> (class_2680)blockState.method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166());
                        this.method_27402(levelSimulatedReader, biConsumer, randomSource, branchPos, treeConfiguration, function);
                        if (length != secondBranchLength) continue;
                        foliageAttachments.add(new class_4647.class_5208(branchPos.method_10084(), 0, false));
                        this.method_35375(levelSimulatedReader, biConsumer, randomSource, branchPos.method_10084(), treeConfiguration);
                    }
                }
            }
            this.method_35375(levelSimulatedReader, biConsumer, randomSource, logPos, treeConfiguration);
            if (i != height) continue;
            foliageAttachments.add(new class_4647.class_5208(logPos.method_10084(), 0, false));
        }
        return foliageAttachments;
    }
}

