import os
import json
import re

def replace_in_json_files(directory):
    print(f"Starting scan in directory: {directory}")
    for root, _, files in os.walk(directory):
        for file in files:
            if file.endswith(".json"):
                file_path = os.path.join(root, file)
                print(f"Processing file: {file_path}")
                try:
                    with open(file_path, 'r', encoding='utf-8') as f:
                        data = json.load(f)

                    modified = replace_silver(data)

                    if modified:
                        with open(file_path, 'w', encoding='utf-8') as f:
                            json.dump(data, f, indent=4)
                        print(f"Updated: {file_path}")
                    else:
                        print(f"No changes needed: {file_path}")

                except json.JSONDecodeError as e:
                    print(f"Invalid JSON in {file_path}: {e}")
                except IOError as e:
                    print(f"File error with {file_path}: {e}")

def replace_silver(data):
    modified = False

    if isinstance(data, dict):
        for key, value in data.items():
            if isinstance(value, (dict, list)):
                if replace_silver(value):
                    modified = True
            elif isinstance(value, str):
                new_value = re.sub(r"(?i)silver", lambda match: match.group(0).replace("silver", "palladium").replace("SILVER", "PALLADIUM"), value)
                if new_value != value:
                    data[key] = new_value
                    modified = True

    elif isinstance(data, list):
        for index, item in enumerate(data):
            if isinstance(item, (dict, list)):
                if replace_silver(item):
                    modified = True
            elif isinstance(item, str):
                new_item = re.sub(r"(?i)silver", lambda match: match.group(0).replace("silver", "palladium").replace("SILVER", "PALLADIUM"), item)
                if new_item != item:
                    data[index] = new_item
                    modified = True

    return modified

# Replace 'your_directory_path' with the path to the target directory
replace_in_json_files(r'C:\\Users\\lunar\\Documents\\GitHub\\Galosphere-Main-Development\\src\\main\\resources')
