/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.orcinus.galosphere.init.GBlocks;

public class PalladiumDustBlock
extends class_5778
implements class_3737 {
    public static final MapCodec<PalladiumDustBlock> CODEC = PalladiumDustBlock.method_54094(PalladiumDustBlock::new);
    public static final class_2746 POWERED = class_2741.field_12484;

    public PalladiumDustBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{POWERED});
    }

    protected boolean method_9579(class_2680 state) {
        return state.method_26227().method_15769();
    }

    protected MapCodec<? extends class_5778> method_53969() {
        return CODEC;
    }

    protected class_1269 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (itemStack.method_31574(class_1802.field_8884) && !((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue()) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.method_64310(blockPos, (class_2248)this, 100);
            level.method_8396(null, blockPos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
            level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, blockPos);
            itemStack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)interactionHand));
            return class_1269.field_5812;
        }
        return super.method_55765(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue()) {
            for (class_2350 direction : class_2350.values()) {
                if (!((Boolean)blockState.method_11654((class_2769)PalladiumDustBlock.method_33374((class_2350)direction))).booleanValue()) continue;
                int amount = class_6019.method_35017((int)8, (int)16).method_35008(randomSource);
                class_243 vec3 = new class_243(direction.method_23955());
                for (int i = 0; i < amount; ++i) {
                    class_5945.method_34681((class_1937)level, (class_2338)blockPos, (class_2350)direction, (class_2394)class_2398.field_11251, (class_243)vec3, (double)0.55);
                }
            }
        }
    }

    private static boolean isWaterThatWouldFlow(class_2338 blockPos, class_1937 level) {
        class_3610 fluidState = level.method_8316(blockPos);
        if (!fluidState.method_15767(class_3486.field_15517)) {
            return false;
        }
        if (fluidState.method_15771()) {
            return true;
        }
        float f = fluidState.method_15761();
        if (f < 2.0f) {
            return false;
        }
        class_3610 fluidState2 = level.method_8316(blockPos.method_10074());
        return !fluidState2.method_15767(class_3486.field_15517);
    }

    protected void method_9588(class_2680 blockState, class_3218 level, class_2338 origin, class_5819 randomSource) {
        if (((Boolean)level.method_8320(origin).method_11654((class_2769)POWERED)).booleanValue()) {
            this.explode(level, origin);
            level.method_8650(origin, false);
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 affectedPosition = origin.method_10093(direction);
            class_2680 relativeState = level.method_8320(affectedPosition);
            if (relativeState.method_27852(GBlocks.PALLADIUM_DUST)) {
                level.method_8652(affectedPosition, (class_2680)relativeState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                level.method_64310(affectedPosition, (class_2248)this, 2);
            }
            for (class_2350 yDirection : class_2350.class_2353.field_11064) {
                class_2680 relativeAboveState = level.method_8320(affectedPosition.method_10093(yDirection));
                if (!relativeAboveState.method_27852(GBlocks.PALLADIUM_DUST)) continue;
                level.method_8652(affectedPosition.method_10093(yDirection), (class_2680)relativeAboveState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                level.method_64310(affectedPosition.method_10093(yDirection), (class_2248)this, 2);
            }
        }
    }

    protected void method_55124(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_1927 explosion, BiConsumer<class_1799, class_2338> biConsumer) {
    }

    private void explode(class_3218 level, final class_2338 origin) {
        boolean bl = class_2350.class_2353.field_11062.method_29716().map(arg_0 -> ((class_2338)origin).method_10093(arg_0)).anyMatch(blockPos -> PalladiumDustBlock.isWaterThatWouldFlow(blockPos, (class_1937)level));
        final boolean bl2 = bl || level.method_8316(origin.method_10084()).method_15767(class_3486.field_15517);
        class_5362 explosionDamageCalculator = new class_5362(this){

            public boolean method_29554(class_1927 explosion, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, float f) {
                if (class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12832().contains("ore")) {
                    return false;
                }
                if (!blockState.method_26215()) {
                    boolean flag = true;
                    for (class_2350 direction : class_2350.values()) {
                        if (!blockGetter.method_8320(blockPos.method_10093(direction)).method_27852(GBlocks.PALLADIUM_DUST)) continue;
                        flag = false;
                    }
                    return flag;
                }
                return true;
            }

            public Optional<Float> method_29555(class_1927 explosion, class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_3610 fluidState) {
                if (blockPos.equals((Object)origin) && bl2) {
                    return Optional.of(Float.valueOf(class_2246.field_10382.method_9520()));
                }
                Optional<Float> resistance = super.method_29555(explosion, blockGetter, blockPos, blockState, fluidState);
                resistance = Optional.of(Float.valueOf(resistance.orElse(Float.valueOf(0.0f)).floatValue() / 2.0f));
                return resistance;
            }
        };
        class_243 vec3 = origin.method_46558();
        float explosion = 3.0f;
        for (class_2350 direction : class_2350.values()) {
            if (!((Boolean)level.method_8320(origin).method_11654((class_2769)PalladiumDustBlock.method_33374((class_2350)direction))).booleanValue()) continue;
            explosion += 0.2f;
        }
        level.method_46407(null, level.method_48963().method_48808(vec3), explosionDamageCalculator, vec3, explosion, false, class_1937.class_7867.field_40889);
    }

    protected int method_9524(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        return (Boolean)blockState.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    protected boolean method_9616(class_2680 blockState, class_1750 blockPlaceContext) {
        return blockPlaceContext.method_8041().method_31574(GBlocks.PALLADIUM_DUST.method_8389());
    }
}

