/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10225;
import net.minecraft.class_1540;
import net.minecraft.class_156;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3962;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GParticleTypes;
import org.jetbrains.annotations.Nullable;

public class PinkSaltStrawBlock
extends class_2248
implements class_3737 {
    public static final class_2754<class_2350> TIP_DIRECTION = class_2741.field_28062;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 FALLABLE = class_2746.method_11825((String)"fallable");
    public static final class_2754<StrawShape> STRAW_SHAPE = class_2754.method_11850((String)"straw_shape", StrawShape.class);
    private static final class_265 REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 TOP_UP_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final class_265 TOP_DOWN_SHAPE = class_2248.method_9541((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 BOTTOM_UP_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_265 BOTTOM_DOWN_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Map<Predicate<class_2680>, SaltReaction> REACTIONS = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(blockState -> blockState.method_27852(class_2246.field_17563) && (Integer)blockState.method_11654((class_2769)class_3962.field_17565) > 0, new SaltReaction(blockState -> GBlocks.SALINE_COMPOSTER.method_34725(blockState), 0.5f));
        map.put(blockState -> ((BiMap)class_5955.field_29564.get()).containsKey((Object)blockState.method_26204()), new SaltReaction(blockState -> ((class_2248)class_5955.method_34737((class_2248)blockState.method_26204()).orElseThrow()).method_34725(blockState), 0.0015f));
    });

    public PinkSaltStrawBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FALLABLE, (Comparable)Boolean.valueOf(false))).method_11657(TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(STRAW_SHAPE, (Comparable)((Object)StrawShape.TOP)));
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        class_2338 tip;
        this.maybeTransferFluid(blockState, serverLevel, blockPos, randomSource.method_43057());
        if (serverLevel.method_8320(blockPos.method_10087(2)).method_27852(class_2246.field_10164) && ((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue() && blockState.method_11654(TIP_DIRECTION) == class_2350.field_11036 && (tip = this.findTip(blockState, (class_1936)serverLevel, blockPos, 7)) != null && serverLevel.method_8316(tip.method_10084()).method_15767(class_3486.field_15517)) {
            serverLevel.method_8501(tip.method_10084(), (class_2680)GBlocks.PINK_SALT_STRAW.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }
    }

    private boolean isStalactiteStartPos(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return PinkSaltStrawBlock.isStalactite(blockState) && !levelReader.method_8320(blockPos.method_10084()).method_27852(GBlocks.PINK_SALT_STRAW);
    }

    public void maybeTransferFluid(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, float f) {
        class_2338 blockPos2 = this.findTip(blockState, (class_1936)serverLevel, blockPos, 11);
        if (blockPos2 == null) {
            return;
        }
        if (!this.isStalactiteStartPos(blockState, (class_4538)serverLevel, blockPos)) {
            return;
        }
        for (Predicate<class_2680> predicate : REACTIONS.keySet()) {
            class_2338 target = this.findTarget((class_1937)serverLevel, blockPos2, predicate);
            if (target == null) continue;
            SaltReaction saltReaction = REACTIONS.get(predicate);
            class_2680 result = saltReaction.function.apply(serverLevel.method_8320(target));
            if (f > saltReaction.chance()) {
                return;
            }
            serverLevel.method_20290(3005, target, 0);
            serverLevel.method_8501(target, result);
        }
    }

    @Nullable
    private class_2338 findTip(class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos2, int i) {
        if (PinkSaltStrawBlock.isTip(blockState2)) {
            return blockPos2;
        }
        class_2350 direction = (class_2350)blockState2.method_11654(TIP_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> blockState.method_27852(GBlocks.PINK_SALT_STRAW) && blockState.method_11654(TIP_DIRECTION) == direction;
        return this.findBlockVertical(levelAccessor, blockPos2, direction.method_10171(), biPredicate, PinkSaltStrawBlock::isTip, i).orElse(null);
    }

    private static boolean isStalactite(class_2680 state) {
        return state.method_27852(GBlocks.PINK_SALT_STRAW) && state.method_11654(TIP_DIRECTION) == class_2350.field_11033;
    }

    @Nullable
    private class_2338 findTarget(class_1937 level, class_2338 blockPos2, Predicate<class_2680> blockStatePredicate) {
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> this.canDripThrough((class_1922)level, (class_2338)blockPos, (class_2680)blockState);
        return this.findBlockVertical((class_1936)level, blockPos2, class_2350.field_11033.method_10171(), biPredicate, blockStatePredicate, 11).orElse(null);
    }

    private boolean canDripThrough(class_1922 blockGetter, class_2338 blockPos, class_2680 blockState) {
        if (blockState.method_26215()) {
            return true;
        }
        if (blockState.method_26216()) {
            return false;
        }
        if (!blockState.method_26227().method_15769()) {
            return false;
        }
        class_265 voxelShape = blockState.method_26220(blockGetter, blockPos);
        return !class_259.method_1074((class_265)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (class_265)voxelShape, (class_247)class_247.field_16896);
    }

    private Optional<class_2338> findBlockVertical(class_1936 levelAccessor, class_2338 blockPos, class_2350.class_2352 axisDirection, BiPredicate<class_2338, class_2680> biPredicate, Predicate<class_2680> predicate, int i) {
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)axisDirection, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (int j = 1; j < i; ++j) {
            mutableBlockPos.method_10098(direction);
            class_2680 blockState = levelAccessor.method_8320((class_2338)mutableBlockPos);
            if (predicate.test(blockState)) {
                return Optional.of(mutableBlockPos.method_10062());
            }
            if (!levelAccessor.method_31601(mutableBlockPos.method_10264()) && biPredicate.test((class_2338)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 randomSource) {
        int bound;
        int n = bound = (Boolean)blockState.method_11654((class_2769)FALLABLE) != false ? 3 : 6;
        if (randomSource.method_43048(bound) == 0 && blockState.method_11654(TIP_DIRECTION) == class_2350.field_11033) {
            double d = (double)blockPos.method_10263() + randomSource.method_43058();
            double e = (double)blockPos.method_10264() - 0.05;
            double f = (double)blockPos.method_10260() + randomSource.method_43058();
            level.method_8406((class_2394)GParticleTypes.PINK_SALT_FALLING_DUST, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, STRAW_SHAPE, TIP_DIRECTION, FALLABLE});
    }

    public void method_19286(class_1937 level, class_2680 blockState, class_3965 blockHitResult, class_1676 projectile) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2338 pos = blockHitResult.method_17777();
        double length = projectile.method_18798().method_1033();
        if (length <= (double)0.4f) {
            return;
        }
        int steps = class_3532.method_15395((class_5819)level.method_8409(), (int)20, (int)30) * class_3532.method_15384((double)length);
        for (int i = 0; i < steps; ++i) {
            boolean flag;
            int radius = 3;
            if (level.method_8409().method_43048(5) == 0) {
                radius *= 2;
            }
            mutableBlockPos.method_10103(pos.method_10263() + class_3532.method_15395((class_5819)level.method_8409(), (int)(-radius), (int)radius), pos.method_10264() + class_3532.method_15395((class_5819)level.method_8409(), (int)-2, (int)2), pos.method_10260() + class_3532.method_15395((class_5819)level.method_8409(), (int)(-radius), (int)radius));
            class_2680 chosenStates = level.method_8320((class_2338)mutableBlockPos);
            boolean bl = flag = chosenStates.method_27852((class_2248)this) && chosenStates.method_11654(TIP_DIRECTION) == class_2350.field_11033 && chosenStates.method_11654(STRAW_SHAPE) == StrawShape.BOTTOM;
            if (!flag) continue;
            level.method_8501((class_2338)mutableBlockPos, (class_2680)chosenStates.method_26204().method_34725(chosenStates).method_11657((class_2769)FALLABLE, (Comparable)Boolean.valueOf(true)));
            double distance = Math.sqrt(projectile.method_5649((double)mutableBlockPos.method_10263(), (double)mutableBlockPos.method_10264(), (double)mutableBlockPos.method_10260()));
            int ticks = Math.max(1, (int)distance);
            level.method_64310((class_2338)mutableBlockPos, (class_2248)this, ticks);
        }
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 access, class_2338 pos, class_2350 direction, class_2338 pos2, class_2680 state2, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            access.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return state;
        }
        class_2350 direction2 = (class_2350)state.method_11654(TIP_DIRECTION);
        if (direction2 == class_2350.field_11033 && access.method_8397().method_8674(pos, (Object)this)) {
            return state;
        }
        if (direction == direction2.method_10153() && !this.method_9558(state, level, pos)) {
            access.method_64310(pos, (class_2248)this, 1);
        }
        StrawShape pinkSaltStrawShape = PinkSaltStrawBlock.calculateStrawShape(level, pos, direction2);
        return (class_2680)state.method_11657(STRAW_SHAPE, (Comparable)((Object)pinkSaltStrawShape));
    }

    private static StrawShape calculateStrawShape(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2350 oppositeDirection = direction.method_10153();
        class_2680 blockState = levelReader.method_8320(blockPos.method_10093(direction));
        class_2680 oppositeState = levelReader.method_8320(blockPos.method_10093(oppositeDirection));
        if (!blockState.method_27852(GBlocks.PINK_SALT_STRAW)) {
            return StrawShape.TOP;
        }
        if (!oppositeState.method_27852(GBlocks.PINK_SALT_STRAW)) {
            return StrawShape.BOTTOM;
        }
        return StrawShape.MIDDLE;
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2350 direction = blockPlaceContext.method_32760().method_10153();
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_1937 levelAccessor = blockPlaceContext.method_8045();
        class_2350 direction2 = PinkSaltStrawBlock.calculateTipDirection((class_4538)levelAccessor, blockPos, direction);
        if (direction2 == null) {
            return null;
        }
        StrawShape pinkSaltStrawShape = PinkSaltStrawBlock.calculateStrawShape((class_4538)levelAccessor, blockPos, direction2);
        if (pinkSaltStrawShape == null) {
            return null;
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(TIP_DIRECTION, (Comparable)direction2)).method_11657(STRAW_SHAPE, (Comparable)((Object)pinkSaltStrawShape))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2350 direction2;
        if (PinkSaltStrawBlock.isValidPinkSaltStraw(levelReader, blockPos, direction)) {
            direction2 = direction;
        } else if (PinkSaltStrawBlock.isValidPinkSaltStraw(levelReader, blockPos, direction.method_10153())) {
            direction2 = direction.method_10153();
        } else {
            return null;
        }
        return direction2;
    }

    private static boolean isValidPinkSaltStraw(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2338 blockPos2 = blockPos.method_10093(direction.method_10153());
        class_2680 blockState = levelReader.method_8320(blockPos2);
        return blockState.method_26206((class_1922)levelReader, blockPos2, direction) || PinkSaltStrawBlock.isPinkSaltStrawWithDirection(blockState, direction);
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return PinkSaltStrawBlock.isValidPinkSaltStrawPlacement(levelReader, blockPos, (class_2350)blockState.method_11654(TIP_DIRECTION));
    }

    private static boolean isValidPinkSaltStrawPlacement(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        class_2338 blockPos2 = blockPos.method_10093(direction.method_10153());
        class_2680 blockState = levelReader.method_8320(blockPos2);
        return blockState.method_26206((class_1922)levelReader, blockPos2, direction) || PinkSaltStrawBlock.isPinkSaltStrawWithDirection(blockState, direction);
    }

    private static boolean isPinkSaltStrawWithDirection(class_2680 blockState, class_2350 direction) {
        return blockState.method_27852(GBlocks.PINK_SALT_STRAW) && blockState.method_11654(TIP_DIRECTION) == direction;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        boolean up;
        class_243 vec3 = blockState.method_26226(blockPos);
        StrawShape value = (StrawShape)((Object)blockState.method_11654(STRAW_SHAPE));
        boolean bl = up = blockState.method_11654(TIP_DIRECTION) == class_2350.field_11036;
        class_265 voxelShape = value == StrawShape.TOP ? (up ? TOP_UP_SHAPE : TOP_DOWN_SHAPE) : (value == StrawShape.BOTTOM ? (up ? BOTTOM_UP_SHAPE : BOTTOM_DOWN_SHAPE) : MIDDLE_SHAPE);
        return voxelShape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)FALLABLE)).booleanValue()) {
            class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
            class_2680 blockState2 = blockState;
            while (blockState2.method_27852(GBlocks.PINK_SALT_STRAW) && blockState2.method_11654(TIP_DIRECTION) == class_2350.field_11033) {
                class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)serverLevel, (class_2338)mutableBlockPos, (class_2680)blockState2);
                if (PinkSaltStrawBlock.isTip(blockState2)) {
                    int i = Math.max(1 + blockPos.method_10264() - mutableBlockPos.method_10264(), 6);
                    float f = i;
                    fallingBlockEntity.method_6965(f, 40);
                    break;
                }
                mutableBlockPos.method_10098(class_2350.field_11033);
                blockState2 = serverLevel.method_8320((class_2338)mutableBlockPos);
            }
        }
        if (!blockState.method_26184((class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        }
    }

    private static boolean isTip(class_2680 blockState) {
        if (!blockState.method_27852(GBlocks.PINK_SALT_STRAW)) {
            return false;
        }
        return blockState.method_11654(STRAW_SHAPE) == StrawShape.TOP;
    }

    public static enum StrawShape implements class_3542
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private StrawShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    record SaltReaction(Function<class_2680, class_2680> function, float chance) {
    }
}

