/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.WeaponRackModel;
import net.orcinus.galosphere.client.renderer.entity.state.WeaponRackRenderState;
import net.orcinus.galosphere.entities.WeaponRack;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GModelLayers;

@Environment(value=EnvType.CLIENT)
public class WeaponRackRenderer
extends class_897<WeaponRack, WeaponRackRenderState> {
    private static final class_2960 TEXTURE = Galosphere.id("textures/entity/weapon_rack/weapon_rack.png");
    private final class_10442 itemModelResolver;
    private final WeaponRackModel model;

    public WeaponRackRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new WeaponRackModel(context.method_32167(GModelLayers.WEAPON_RACK));
        this.itemModelResolver = context.method_65566();
    }

    public void render(WeaponRackRenderState entityRenderState, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        float g;
        float f;
        super.method_3936((class_10017)entityRenderState, poseStack, multiBufferSource, i);
        poseStack.method_22903();
        class_2350 direction = entityRenderState.direction;
        class_243 vec3 = this.getRenderOffset(entityRenderState);
        poseStack.method_22904(-vec3.method_10216(), -vec3.method_10214(), -vec3.method_10215());
        poseStack.method_22904((double)direction.method_10148() * 0.46875, (double)direction.method_10164() * 0.46875, (double)direction.method_10165() * 0.46875);
        if (direction.method_10166().method_10179()) {
            f = 0.0f;
            g = 180.0f - direction.method_10144();
        } else {
            f = -90 * direction.method_10171().method_10181();
            g = 180.0f;
        }
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(g));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(135.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)entityRenderState.rotation * 360.0f / 8.0f));
        poseStack.method_22903();
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23572((class_2960)TEXTURE));
        poseStack.method_46416(0.0f, -1.0f, 0.0f);
        this.model.method_60879(poseStack, vertexConsumer, i, class_4608.field_21444);
        poseStack.method_22909();
        float shift = entityRenderState.xshift;
        float yShift = entityRenderState.yShift;
        float zShift = entityRenderState.zShift;
        poseStack.method_46416(shift, yShift, zShift);
        float rotation = entityRenderState.projectileRotation;
        float xprotation = entityRenderState.xpRotation;
        float yprotation = entityRenderState.ypRotation;
        if (!entityRenderState.item.method_65606()) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(xprotation));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(yprotation));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(rotation));
            poseStack.method_22905(1.0f, 1.0f, 1.0f);
            entityRenderState.item.method_65604(poseStack, multiBufferSource, i, class_4608.field_21444);
        }
        poseStack.method_22909();
    }

    public void extractRenderState(WeaponRack entity, WeaponRackRenderState entityRenderState, float f) {
        super.method_62354((class_1297)entity, (class_10017)entityRenderState, f);
        class_1799 itemStack = entity.getItem();
        boolean ranged = itemStack.method_31573(ConventionalItemTags.RANGED_WEAPON_TOOLS) && !itemStack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS);
        boolean nonTools = itemStack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS) || ranged || itemStack.method_31573(ConventionalItemTags.BRUSH_TOOLS);
        class_811 fixed = itemStack.method_31574(class_1802.field_8547) ? class_811.field_4322 : class_811.field_4319;
        this.itemModelResolver.method_65595(entityRenderState.item, itemStack, fixed, (class_1297)entity);
        entityRenderState.direction = entity.method_5735();
        entityRenderState.rotation = entity.getRotation();
        float f2 = entityRenderState.xshift = nonTools ? 0.0f : -0.05f;
        if (itemStack.method_31574(class_1802.field_8547)) {
            entityRenderState.yShift = 0.25f;
            entityRenderState.zShift = 0.1575f;
            entityRenderState.projectileRotation = 90.0f;
            entityRenderState.xpRotation = 90.0f;
            entityRenderState.ypRotation = 115.0f;
        } else if (itemStack.method_31574(GItems.ECHO_BELL)) {
            entityRenderState.xshift = 0.01f;
            entityRenderState.yShift = -0.095f;
        } else if (ranged) {
            entityRenderState.yShift = -0.015f;
            entityRenderState.zShift = 0.4675f;
            entityRenderState.projectileRotation = 45.0f;
            entityRenderState.xpRotation = 0.0f;
            entityRenderState.ypRotation = 0.0f;
        } else {
            entityRenderState.yShift = -0.035f;
            entityRenderState.zShift = 0.4675f;
            entityRenderState.projectileRotation = 135.0f;
            entityRenderState.xpRotation = 0.0f;
            entityRenderState.ypRotation = 0.0f;
        }
    }

    public class_243 getRenderOffset(WeaponRackRenderState entityRenderState) {
        return new class_243((double)((float)entityRenderState.direction.method_10148() * 0.3f), -0.25, (double)((float)entityRenderState.direction.method_10165() * 0.3f));
    }

    public WeaponRackRenderState createRenderState() {
        return new WeaponRackRenderState();
    }
}

