/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.class_10209;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_5757;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7924;
import net.minecraft.class_9849;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.entities.navigation.SemiAquaticPathNavigation;
import net.orcinus.galosphere.entities.variants.SparkleVariant;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GEntityDataSerializers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GRegistries;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSparkleVariants;
import org.jetbrains.annotations.Nullable;

public class Sparkle
extends class_1429 {
    private static final class_2940<class_6880<SparkleVariant>> VARIANT = class_2945.method_12791(Sparkle.class, GEntityDataSerializers.SPARKLE_VARIANT);
    protected static final ImmutableList<? extends class_4149<? extends class_4148<? super Sparkle>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, GSensorTypes.SPARKLE_TEMPTATIONS, GSensorTypes.NEAREST_POLLINATED_CLUSTER, (Object)class_4149.field_37447);
    protected static final ImmutableList<? extends class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18448, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_28327, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object[])new class_4140[]{class_4140.field_30243, class_4140.field_37442, class_4140.field_39408, GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER, GMemoryModuleTypes.POLLINATED_COOLDOWN});
    private static final class_6019 REGROWTH_TICKS = class_6019.method_35017((int)6000, (int)12000);
    public final class_9849 inWaterAnimator = new class_9849(10, class_3532::method_61346);
    public final class_9849 movingAnimator = new class_9849(10, class_3532::method_61346);
    private int growthTicks;

    public Sparkle(class_1299<? extends Sparkle> type, class_1937 world) {
        super(type, world);
        this.method_5941(class_7.field_18, 4.0f);
        this.method_5941(class_7.field_19, -1.0f);
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
    }

    public float method_49476() {
        return 1.0f;
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        return 0.0f;
    }

    protected class_4095.class_5303<Sparkle> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return SparkleAi.makeBrain((class_4095<Sparkle>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Sparkle> method_18868() {
        return super.method_18868();
    }

    protected void method_5958(class_3218 serverLevel) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("sparkleBrain");
        this.method_18868().method_19542(serverLevel, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("sparkleActivityUpdate");
        SparkleAi.updateActivity(this);
        profiler.method_15407();
        super.method_5958(serverLevel);
    }

    public static boolean isValidTargetState(class_1937 level, class_2338 blockPos, class_1309 livingEntity) {
        class_2680 state = level.method_8320(blockPos);
        return state.method_26164(GBlockTags.CRYSTAL_CLUSTERS) && (!(state.method_26204() instanceof PollinatedClusterBlock) || (Boolean)state.method_11654((class_2769)PollinatedClusterBlock.POLLINATED) == false);
    }

    public void method_6091(class_243 vec3) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), vec3);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(vec3);
        }
    }

    public boolean method_5675() {
        return false;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_23716, 10.0);
    }

    public int method_5978() {
        return 1;
    }

    public int method_5986() {
        return 1;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        class_5455 registryAccess = this.method_56673();
        class_2378 registry = registryAccess.method_30530(GRegistries.SPARKLE_VARIANT);
        builder.method_56912(VARIANT, (Object)((class_6880)registry.method_46746(GSparkleVariants.DEFAULT).or(() -> ((class_2378)registry).method_60385()).orElseThrow()));
    }

    public static boolean checkSparkleSpawnRules(class_1299<? extends class_1309> sparkle, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(GBlockTags.SPARKLES_SPAWNABLE_ON);
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 entitySpawnReason, @Nullable class_1315 spawnGroupData) {
        this.setVariant(this.getNonDefaultRandomVariant());
        return super.method_5943(serverLevelAccessor, difficultyInstance, entitySpawnReason, spawnGroupData);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        Optional.ofNullable(class_2960.method_12829((String)tag.method_10558("variant"))).map(resourceLocation -> class_5321.method_29179(GRegistries.SPARKLE_VARIANT, (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(GRegistries.SPARKLE_VARIANT).method_46746(resourceKey)).ifPresent(this::setVariant);
        this.setGrowthTicks(tag.method_10550("GrowthTicks"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.getVariant().method_40230().ifPresent(resourceKey -> tag.method_10582("variant", resourceKey.method_29177().toString()));
        tag.method_10569("GrowthTicks", this.getGrowthTicks());
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    protected class_1408 method_5965(class_1937 world) {
        return new SemiAquaticPathNavigation((class_1308)this, world);
    }

    public void setVariant(class_6880<SparkleVariant> holder) {
        this.field_6011.method_12778(VARIANT, holder);
    }

    public class_6880<SparkleVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(GItemTags.SPARKLE_TEMPT_ITEMS);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 mob) {
        Sparkle sparkleEntity = (Sparkle)GEntityTypes.SPARKLE.method_5883((class_1937)world, class_3730.field_16466);
        if (sparkleEntity != null) {
            sparkleEntity.setVariant((class_6880<SparkleVariant>)world.method_30349().method_30530(GRegistries.SPARKLE_VARIANT).method_46747(GSparkleVariants.DEFAULT));
        }
        return sparkleEntity;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() && this.getVariant() == this.getDefaultVariant()) {
            if (this.getGrowthTicks() > 0) {
                this.setGrowthTicks(this.getGrowthTicks() - 1);
            } else {
                this.setVariant(this.getNonDefaultRandomVariant());
            }
        }
    }

    private class_6880<SparkleVariant> getNonDefaultRandomVariant() {
        class_2378 registry = this.method_37908().method_30349().method_30530(GRegistries.SPARKLE_VARIANT);
        Optional optional = registry.method_10240(this.method_59922());
        return (class_6880)optional.orElseThrow();
    }

    private class_6880<SparkleVariant> getDefaultVariant() {
        return this.method_37908().method_30349().method_30530(GRegistries.SPARKLE_VARIANT).method_46747(GSparkleVariants.DEFAULT);
    }

    public void method_5670() {
        super.method_5670();
        if (this.method_37908().field_9236) {
            this.inWaterAnimator.method_61340(this.method_5799());
            boolean bl = this.field_42108.method_48571() || this.method_36455() != this.field_6004 || this.method_36454() != this.field_5982;
            this.movingAnimator.method_61340(bl);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.getVariant() != this.getDefaultVariant() && stack.method_31573(class_3489.field_42614) && !this.method_6109()) {
            this.extractShard(stack);
            stack.method_7970(1, (class_1309)player, Sparkle.method_56079((class_1268)hand));
            this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
            return class_1269.field_5812;
        }
        if (this.getVariant() == this.getDefaultVariant() && stack.method_31573(GItemTags.SPARKLE_TEMPT_ITEMS)) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.setGrowthTicks(this.getGrowthTicks() - class_3532.method_15395((class_5819)this.field_5974, (int)600, (int)1000));
            this.method_5783(class_3417.field_40076, 1.0f, 1.0f);
            this.method_32876((class_6880)class_5712.field_28735);
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void extractShard(class_1799 stack) {
        this.spawnShard(stack);
        this.method_5783(class_3417.field_26951, 1.0f, 1.0f);
        this.setVariant(this.getDefaultVariant());
        this.setGrowthTicks(REGROWTH_TICKS.method_35008(this.method_59922()));
    }

    private void spawnShard(class_1799 stack) {
        Optional<class_1792> item;
        class_2378 lookup = this.method_37908().method_30349().method_30530(class_7924.field_41265);
        SparkleVariant sparkleVariant = (SparkleVariant)this.getVariant().comp_349();
        Optional<class_1792> optional = item = class_1890.method_8225((class_6880)lookup.method_46747(class_1893.field_9099), (class_1799)stack) > 0 ? sparkleVariant.crystal() : sparkleVariant.item();
        if (item.isEmpty()) {
            return;
        }
        int fortuneLevel = class_1890.method_8225((class_6880)lookup.method_46747(class_1893.field_9130), (class_1799)stack);
        int rolls = fortuneLevel > 0 ? class_3532.method_15395((class_5819)this.field_5974, (int)0, (int)2) * fortuneLevel : 1;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (int i = 0; i < rolls; ++i) {
                this.method_5706(serverLevel, (class_1935)item.get());
            }
        }
    }
}

