/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5134;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Smash
extends class_4097<Berserker> {
    private static final int DURATION = class_3532.method_15386((float)27.0f);
    private static final int MAX_DURATION = 60;

    public Smash() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.RAMPAGE_TICKS, (Object)class_4141.field_18457, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_18442, (Object)class_4141.field_18456, GMemoryModuleTypes.IS_SMASHING, (Object)class_4141.field_18458, GMemoryModuleTypes.IS_IMPALING, (Object)class_4141.field_18457, GMemoryModuleTypes.IS_SUMMONING, (Object)class_4141.field_18457, GMemoryModuleTypes.IS_HALITE_ATTACKING, (Object)class_4141.field_18457, GMemoryModuleTypes.SMASHING_COOLDOWN, (Object)class_4141.field_18457), 60);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkExtraStartConditions(class_3218 serverLevel, Berserker livingEntity) {
        Optional memory = livingEntity.method_18868().method_18904(class_4140.field_22355);
        if (!livingEntity.shouldAttack()) return false;
        if (!memory.filter(arg_0 -> ((Berserker)livingEntity).method_42150(arg_0)).isPresent()) return false;
        return true;
    }

    protected boolean canStillUse(class_3218 serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(class_3218 serverLevel, Berserker livingEntity, long l) {
        class_4095<Berserker> brain = livingEntity.method_18868();
        brain.method_24525(class_4140.field_22475, (Object)true, (long)DURATION);
        brain.method_24525(GMemoryModuleTypes.IS_SMASHING, (Object)class_3902.field_17274, 60L);
        livingEntity.setPhase(Berserker.Phase.SMASH);
        livingEntity.method_5783(GSoundEvents.BERSERKER_DUO_SMASH, 10.0f, 1.0f);
    }

    protected void tick(class_3218 level, Berserker self, long l) {
        self.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> self.method_5988().method_19615(target.method_19538()));
        self.method_18868().method_18875(class_4140.field_18445);
        if (self.method_18868().method_18896(class_4140.field_22475)) {
            return;
        }
        List<class_1309> list = level.method_18467(class_1309.class, self.method_5829().method_1014(8.0)).stream().filter(living -> self.canTargetEntity(level, (class_1297)living)).filter(e -> e.method_5667() != self.method_5667()).toList();
        for (class_1309 enemy : list) {
            class_243 selfPos = self.method_19538().method_1031(0.0, (double)1.6f, 0.0);
            class_243 enemyPos = enemy.method_33571().method_1020(selfPos);
            class_243 normalizedDirection = enemyPos.method_1029();
            double knockbackX = 0.5 * (1.0 - enemy.method_45325(class_5134.field_23718));
            double knockbackY = 2.5 * (1.0 - enemy.method_45325(class_5134.field_23718));
            double distanceFromEnemy = self.method_5739((class_1297)enemy);
            boolean canDamage = true;
            if (distanceFromEnemy > 3.0 && !enemy.method_24828()) {
                canDamage = false;
            }
            if (!canDamage) continue;
            self.method_6121(level, (class_1297)enemy);
            self.method_6025(10.0f);
            enemy.method_5762(normalizedDirection.method_10216() * knockbackY, normalizedDirection.method_10214() * knockbackX, normalizedDirection.method_10215() * knockbackY);
        }
        self.method_37908().method_8421((class_1297)self, (byte)32);
        self.method_18868().method_24525(class_4140.field_22475, (Object)true, (long)(60 - DURATION));
    }

    protected void stop(class_3218 serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
    }
}

