/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.orcinus.galosphere.blocks.blockentities.MoleBurrowBlockEntity;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class ReturnBurrow
extends class_4097<Mole> {
    public ReturnBurrow() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.MOLE_RETURNING, (Object)class_4141.field_18456), 600);
    }

    protected boolean checkExtraStartConditions(class_3218 serverLevel, Mole livingEntity) {
        MoleBurrowBlockEntity moleBurrowBlock;
        boolean flag1;
        class_2338 pos = livingEntity.getBurrowPos();
        if (pos == null) {
            return false;
        }
        boolean flag = !serverLevel.method_8320(pos).method_27852(GBlocks.MOLE_BURROW);
        class_2586 class_25862 = serverLevel.method_8321(pos);
        boolean bl = flag1 = class_25862 instanceof MoleBurrowBlockEntity && !(moleBurrowBlock = (MoleBurrowBlockEntity)class_25862).isEmpty();
        if (flag || flag1) {
            livingEntity.setBurrowPos(null);
            return false;
        }
        return true;
    }

    protected boolean canStillUse(class_3218 serverLevel, Mole livingEntity, long l) {
        MoleBurrowBlockEntity moleBurrowBlock;
        class_2586 class_25862;
        class_2338 pos = livingEntity.getBurrowPos();
        if (pos != null && (!serverLevel.method_8320(pos).method_27852(GBlocks.MOLE_BURROW) || (class_25862 = serverLevel.method_8321(pos)) instanceof MoleBurrowBlockEntity && !(moleBurrowBlock = (MoleBurrowBlockEntity)class_25862).isEmpty())) {
            livingEntity.setBurrowPos(null);
            return false;
        }
        if (livingEntity.method_18868().method_18896(GMemoryModuleTypes.MOLE_DIGGING)) {
            return livingEntity.method_18868().method_36978(GMemoryModuleTypes.MOLE_DIGGING) > 0L;
        }
        return this.checkExtraStartConditions(serverLevel, livingEntity);
    }

    protected void tick(class_3218 serverLevel, Mole livingEntity, long l) {
        if (livingEntity.method_18868().method_18896(GMemoryModuleTypes.MOLE_DIGGING)) {
            livingEntity.method_18868().method_18875(class_4140.field_18445);
            livingEntity.transitionTo(Mole.State.DIGGING);
            return;
        }
        if (this.canBurrow(livingEntity)) {
            livingEntity.method_18868().method_24525(GMemoryModuleTypes.MOLE_DIGGING, (Object)class_3902.field_17274, 40L);
            return;
        }
        Optional.ofNullable(livingEntity.getBurrowPos()).ifPresent(blockPos -> livingEntity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(blockPos.method_10084(), 1.65f, 0)));
    }

    protected void stop(class_3218 serverLevel, Mole livingEntity, long l) {
        MoleBurrowBlockEntity moleBurrowBlock;
        class_2586 class_25862;
        if (livingEntity.getBurrowPos() != null && (class_25862 = serverLevel.method_8321(livingEntity.getBurrowPos())) instanceof MoleBurrowBlockEntity && (moleBurrowBlock = (MoleBurrowBlockEntity)class_25862).isEmpty()) {
            moleBurrowBlock.addMole((class_1297)livingEntity);
        } else {
            livingEntity.transitionTo(Mole.State.IDLING);
        }
    }

    private boolean canBurrow(Mole mole) {
        if (mole.getBurrowPos() == null) {
            return false;
        }
        class_2338 blockPos = mole.method_24515();
        class_2338 above = mole.getBurrowPos().method_10084();
        return blockPos.equals((Object)above);
    }
}

