/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.items.components.EchobellTracker;

public class HandbellManager {
    public static boolean shouldResonate(class_1657 player) {
        Predicate<class_1799> predicate = itemStack -> {
            EchobellTracker minersBell = (EchobellTracker)itemStack.method_57824(GDataComponents.ECHO_BELL_TRACKER);
            return itemStack.method_31574(GItems.ECHO_BELL) && minersBell != null && minersBell.shouldActivate();
        };
        return player.method_31548().method_55753(predicate);
    }

    public static void resonance(class_3218 serverLevel, class_1657 player, class_5819 random, int xzRange, int yRange, int particleRange) {
        HandbellManager.handbellTick(player);
        HandbellManager.handleOreResonance(serverLevel, player, random, xzRange, yRange, particleRange);
    }

    private static void handleOreResonance(class_3218 serverLevel, class_1657 player, class_5819 random, int xzRange, int yRange, int particleRange) {
        for (class_2338 blockPos : class_2338.method_25996((class_2338)player.method_24515(), (int)xzRange, (int)yRange, (int)xzRange)) {
            boolean flag = HandbellManager.validTarget(player, serverLevel, blockPos) && random.method_43057() < 0.07f;
            if (!flag) continue;
            class_2338 pos2 = blockPos.method_10069(class_3532.method_32751((class_5819)random, (int)(-particleRange), (int)particleRange), class_3532.method_32751((class_5819)random, (int)(-particleRange), (int)particleRange), class_3532.method_32751((class_5819)random, (int)(-particleRange), (int)particleRange));
            int count = class_6019.method_35017((int)3, (int)6).method_35008(random);
            HandbellManager.spawnParticles(serverLevel, blockPos, count, pos2);
        }
    }

    private static void handbellTick(class_1657 player) {
        for (class_1799 itemStack : player.method_31548().field_7547) {
            EchobellTracker handbellTracker;
            if (!itemStack.method_31574(GItems.ECHO_BELL) || (handbellTracker = (EchobellTracker)itemStack.method_57824(GDataComponents.ECHO_BELL_TRACKER)) == null || handbellTracker.ticks() >= (int)player.method_37908().method_8510()) continue;
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14979, class_3419.field_15254, 1.0f, 1.0f);
            itemStack.method_57379(GDataComponents.ECHO_BELL_TRACKER, (Object)new EchobellTracker(handbellTracker.fuel() - 1, false, 1200));
        }
    }

    private static boolean validTarget(class_1657 player, class_3218 serverLevel, class_2338 blockPos) {
        class_2680 state = serverLevel.method_8320(blockPos);
        if (state.method_26164(ConventionalBlockTags.ORES) && !state.method_26164(GBlockTags.MINER_BELL_NON_DETECTABLES)) {
            Optional<class_2350> optional = Arrays.stream(class_2350.values()).filter(direction -> serverLevel.method_16358(blockPos.method_10093(direction), class_5726::method_33389)).findAny();
            double distance = player.method_24515().method_19455((class_2382)blockPos);
            if (distance < 6.0) {
                return optional.isEmpty();
            }
            return true;
        }
        return false;
    }

    private static void spawnParticles(class_3218 serverLevel, class_2338 blockPos, int count, class_2338 pos2) {
        for (int i = 0; i < count; ++i) {
            int[] color = new int[]{2744299, 37525, 675936};
            if (serverLevel.method_8320(pos2).method_26234((class_1922)serverLevel, pos2)) continue;
            float velX = 0.06f * (float)(blockPos.method_10263() - pos2.method_10263());
            float velY = 0.06f * (float)(blockPos.method_10264() - pos2.method_10264());
            float velZ = 0.06f * (float)(blockPos.method_10260() - pos2.method_10260());
            serverLevel.method_65096((class_2394)GParticleTypes.ECHO_TRAIL, (double)((float)pos2.method_10263() + 0.5f), (double)pos2.method_10264(), (double)((float)pos2.method_10260() + 0.5f), 0, (double)velX, (double)velY, (double)velZ, 1.0);
        }
        if (serverLevel.method_8409().method_43057() < 0.01f) {
            serverLevel.method_8396(null, blockPos, class_3417.field_43154, class_3419.field_15245, 1.0f, 1.0f);
        }
    }
}

