/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6016;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.world.gen.features.config.CrystalSpikeConfig;

public class CrystalSpikeFeature
extends class_3031<CrystalSpikeConfig> {
    public CrystalSpikeFeature(Codec<CrystalSpikeConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<CrystalSpikeConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        CrystalSpikeConfig config = (CrystalSpikeConfig)context.method_33656();
        HashSet trigList = Sets.newHashSet();
        HashSet clusterPos = Sets.newHashSet();
        boolean flag = false;
        int radiusCheck = config.xzRadius().method_35008(random) + 1;
        int randomChance = random.method_43048(4);
        int stepHeight = radiusCheck + 14 + class_3532.method_15395((class_5819)random, (int)10, (int)14);
        if (world.method_16358(blockPos.method_10093(config.crystal_direction().method_34379().method_10153()), class_5726::method_33389) && world.method_8320(blockPos).method_26164(class_3481.field_25806)) {
            if (!world.method_16358(blockPos.method_10079(config.crystal_direction().method_34379().method_10153(), 5), class_5726::method_33389)) {
                if (radiusCheck < 4) {
                    radiusCheck /= 2;
                } else {
                    return false;
                }
            }
            if (this.placeSpike((class_1936)world, blockPos, radiusCheck, stepHeight, randomChance, trigList, config.crystal_direction().method_34379(), random)) {
                flag = this.placeCrystals(world, random, config, trigList, clusterPos, flag);
            }
        }
        return flag;
    }

    private boolean placeCrystals(class_5281 world, class_5819 random, CrystalSpikeConfig config, HashSet<class_2338> trigList, HashSet<class_2338> clusterPos, boolean flag) {
        for (class_2338 pos : trigList) {
            if (!world.method_16358(pos, class_5726::method_33389)) continue;
            this.method_13153((class_1945)world, pos, config.crystal_state());
            clusterPos.add(pos);
            flag = true;
        }
        for (class_2338 pos : clusterPos) {
            if (random.method_43048(6) != 0) continue;
            for (class_2350 direction : class_2350.values()) {
                class_2338 relative = pos.method_10093(direction);
                if (!random.method_43056() || !world.method_16358(relative, class_5726::method_33014) || !world.method_8320(pos).equals(config.crystal_state())) continue;
                class_2680 blockState = random.method_43057() > config.glinted_cluster_chance() ? config.cluster_state() : config.glinted_cluster();
                this.method_13153((class_1945)world, relative, (class_2680)((class_2680)blockState.method_11657((class_2769)PollinatedClusterBlock.field_27087, (Comparable)direction)).method_11657((class_2769)PollinatedClusterBlock.field_27086, (Comparable)Boolean.valueOf(world.method_8316(relative).method_15772() == class_3612.field_15910)));
            }
        }
        return flag;
    }

    public boolean placeSpike(class_1936 world, class_2338 blockPos, int startRadius, int height, int randomChance, HashSet<class_2338> crystalPos, class_2350 direction, class_5819 random) {
        boolean flag = false;
        if (startRadius < 1) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            int radius = startRadius - y / 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264(), blockPos.method_10260() + z);
                    if (x * x + z * z > radius * radius) continue;
                    if (direction == class_2350.field_11033) {
                        if (world.method_16358(pos.method_10074(), class_5726::method_33389)) {
                            return this.placeSpike(world, blockPos.method_10074(), startRadius / 2, height, randomChance, crystalPos, direction, random);
                        }
                    } else if (direction == class_2350.field_11036) {
                        class_2338.class_2339 mut = pos.method_25503();
                        for (int i = 0; i < 10 && world.method_16358(mut.method_10084(), class_5726::method_33389); ++i) {
                            mut.method_10098(class_2350.field_11036);
                        }
                        pos = mut.method_10062();
                        if (world.method_16358(pos.method_10084(), class_5726::method_33389)) {
                            return false;
                        }
                    }
                    this.calciteBloom(world, pos.method_10093(direction), random, radius);
                    float delta = switch (randomChance) {
                        case 1 -> 5.759587f;
                        case 2 -> 0.5235988f;
                        case 3 -> 3.6651917f;
                        case 0 -> 2.617994f;
                        default -> throw new IllegalStateException("Unexpected value: " + randomChance);
                    };
                    float q = class_3532.method_15362((float)delta) * (float)y;
                    float k = class_3532.method_15374((float)1.5707964f) * (float)y;
                    float l = class_3532.method_15374((float)delta) * (float)y;
                    float xx = direction == class_2350.field_11036 ? -q : q;
                    float yy = direction == class_2350.field_11036 ? -k : k;
                    float zz = direction == class_2350.field_11036 ? -l : l;
                    class_2338 trigPos = class_2338.method_49637((double)((float)pos.method_10263() + xx), (double)((float)pos.method_10264() + yy), (double)((float)pos.method_10260() + zz));
                    if (world.method_16358(trigPos, class_5726::method_33389)) {
                        crystalPos.add(trigPos);
                        flag = true;
                        continue;
                    }
                    crystalPos.remove(trigPos);
                }
            }
        }
        return flag;
    }

    private boolean calciteBloom(class_1936 world, class_2338 blockPos, class_5819 random, int crystalRadius) {
        int radius = crystalRadius / 4;
        int height = class_6016.method_34998((int)2).method_35008(random);
        boolean flag = false;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    class_2338 pos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z);
                    for (class_2350 direction : class_2350.values()) {
                        if (!world.method_8320(pos).method_26164(class_3481.field_25806) || !world.method_16358(pos.method_10093(direction), class_5726::method_33389)) continue;
                        world.method_8652(pos, class_2246.field_27114.method_9564(), 2);
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }
}

