/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.blocks.blockentities.BurrowAnchorBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import org.jetbrains.annotations.Nullable;

public class BurrowAnchorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BurrowAnchorBlock> CODEC = BurrowAnchorBlock.simpleCodec(BurrowAnchorBlock::new);
    private static final VoxelShape SHAPE = BurrowAnchorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BurrowAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BurrowAnchorBlockEntity(blockPos, blockState);
    }

    @Nullable
    private BlockPos getAdjacentPos(Level level, List<BlockPos> foundPoses, BlockPos blockPos, Direction exclude, boolean stop, int distance) {
        if (distance > 128 || stop) {
            return null;
        }
        Collection directions = Direction.allShuffled((RandomSource)level.getRandom());
        for (Direction direction : directions) {
            if (direction == exclude || !level.getBlockState(blockPos.relative(direction)).is(Blocks.SCULK)) continue;
            ++distance;
            if (level.getBlockState(blockPos.relative(direction).above()).is((Block)GBlocks.BURROW_ANCHOR.get())) {
                return blockPos.relative(direction).above();
            }
            if (foundPoses.contains(blockPos.relative(direction))) break;
            foundPoses.add(blockPos.relative(direction));
            return this.getAdjacentPos(level, foundPoses, blockPos.relative(direction), direction.getOpposite(), false, distance);
        }
        return null;
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (level instanceof ServerLevel) {
            Player player;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Player && (player = (Player)entity).isCrouching()) {
                ArrayList foundPoses;
                BlockPos findDestination;
                int distance = 0;
                if (level.getBlockState(blockPos.below()).is(Blocks.SCULK) && (findDestination = this.getAdjacentPos(level, foundPoses = Lists.newArrayList(), blockPos.below(), null, false, distance)) != null) {
                    BurrowAnchorBlockEntity burrowAnchorBlockEntity;
                    BlockEntity blockEntity;
                    entity.teleportTo((double)findDestination.getX() + 0.5, (double)findDestination.getY(), (double)findDestination.getZ() + 0.5);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        GCriteriaTriggers.WARPED_TELEPORT.get().trigger(serverPlayer);
                    }
                    if ((blockEntity = serverLevel.getBlockEntity(blockPos)) instanceof BurrowAnchorBlockEntity) {
                        burrowAnchorBlockEntity = (BurrowAnchorBlockEntity)blockEntity;
                        serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                        burrowAnchorBlockEntity.setCooldown(60);
                    }
                    if ((blockEntity = serverLevel.getBlockEntity(findDestination)) instanceof BurrowAnchorBlockEntity) {
                        burrowAnchorBlockEntity = (BurrowAnchorBlockEntity)blockEntity;
                        serverLevel.setBlock(findDestination, (BlockState)serverLevel.getBlockState(findDestination).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                        burrowAnchorBlockEntity.setCooldown(60);
                    }
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BurrowAnchorBlock.createTickerHelper(blockEntityType, GBlockEntityTypes.BURROW_ANCHOR.get(), BurrowAnchorBlockEntity::tick);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos2, BlockState state2, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            access.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, access, pos, direction, pos2, state2, random);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

