/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.blockentities.GlowInkClumpsBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class GlowInkClumpsBlock
extends MultifaceBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final MapCodec<GlowInkClumpsBlock> CODEC = GlowInkClumpsBlock.simpleCodec(GlowInkClumpsBlock::new);
    private static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    private static final BooleanProperty NATURAL = BlockStateProperties.NATURAL;

    public GlowInkClumpsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE, NATURAL});
    }

    protected ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return new ItemStack((ItemLike)Items.GLOW_INK_SAC);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        return !ctx.getItemInHand().is(Items.GLOW_INK_SAC) || super.canBeReplaced(state, ctx);
    }

    protected boolean propagatesSkylightDown(BlockState blockState) {
        return blockState.getFluidState().isEmpty();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GlowInkClumpsBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState p_153213_, BlockEntityType<T> type) {
        return world.isClientSide ? null : (type == GBlockEntityTypes.GLOW_INK_CLUMPS.get() ? (level, pos, state, te) -> GlowInkClumpsBlockEntity.serverTick(level, pos, state, (GlowInkClumpsBlockEntity)te) : null);
    }
}

