/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.blocks.blockentities.MoleBurrowBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.util.quests.IndexedQuest;
import net.orcinus.galosphere.util.quests.MiningPouchManager;
import org.jetbrains.annotations.Nullable;

public class MoleBurrowBlock
extends BaseEntityBlock {
    public static final MapCodec<MoleBurrowBlock> CODEC = MoleBurrowBlock.simpleCodec(MoleBurrowBlock::new);
    public static final IntegerProperty POUCHES = IntegerProperty.create((String)"pouches", (int)0, (int)3);

    public MoleBurrowBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POUCHES, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POUCHES});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MoleBurrowBlockEntity(blockPos, blockState);
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        IndexedQuest miningPouch = (IndexedQuest)itemStack.get(GDataComponents.QUESTS.get());
        if (itemStack.is((Item)GItems.MINING_POUCH.get()) && miningPouch != null && miningPouch.requests().isEmpty()) {
            MoleBurrowBlockEntity moleBurrowBlockEntity;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (!(blockEntity instanceof MoleBurrowBlockEntity) || (moleBurrowBlockEntity = (MoleBurrowBlockEntity)blockEntity).getRarity() != null) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            moleBurrowBlockEntity.setRarity(miningPouch.rarity());
            level.playSound(null, blockPos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemStack.shrink(1);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        int pouches = (Integer)blockState.getValue((Property)POUCHES);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (pouches > 0) {
                ItemStack pouch = MiningPouchManager.getPouch(serverLevel, blockPos);
                DefaultDispenseItemBehavior.spawnItem((Level)level, (ItemStack)pouch, (int)2, (Direction)Direction.UP, (Position)Vec3.atBottomCenterOf((Vec3i)blockPos).relative(Direction.UP, 1.2));
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)POUCHES, (Comparable)Integer.valueOf(pouches - 1)));
                level.playSound(null, blockPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.2, (double)blockPos.getZ() + 0.5, 15, 0.0, 0.0, 0.0, 0.0);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return InteractionResult.PASS;
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : MoleBurrowBlock.createTickerHelper(blockEntityType, GBlockEntityTypes.MOLE_BURROW.get(), MoleBurrowBlockEntity::serverTick);
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.playerDestroy(level, player, blockPos, blockState, blockEntity, itemStack);
        if (!level.isClientSide && blockEntity instanceof MoleBurrowBlockEntity) {
            MoleBurrowBlockEntity moleBurrowBlockEntity = (MoleBurrowBlockEntity)blockEntity;
            if (!EnchantmentHelper.hasTag((ItemStack)itemStack, (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                moleBurrowBlockEntity.releaseAllOccupants(blockState, MoleBurrowBlockEntity.MoleReleaseStatus.EMERGENCY);
                level.updateNeighbourForOutputSignal(blockPos, (Block)this);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.isClientSide() && level instanceof ServerLevel) {
            MoleBurrowBlockEntity moleBurrowBlockEntity;
            BlockEntity blockEntity;
            ServerLevel server = (ServerLevel)level;
            if (player.isCreative() && server.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = level.getBlockEntity(blockPos)) instanceof MoleBurrowBlockEntity && !(moleBurrowBlockEntity = (MoleBurrowBlockEntity)blockEntity).isEmpty()) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                itemStack.applyComponents(moleBurrowBlockEntity.collectComponents());
                ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), itemStack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }
}

