/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.init.GBlocks;

public class PalladiumDustBlock
extends MultifaceBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PalladiumDustBlock> CODEC = PalladiumDustBlock.simpleCodec(PalladiumDustBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public PalladiumDustBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (itemStack.is(Items.FLINT_AND_STEEL) && !((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.scheduleTick(blockPos, (Block)this, 100);
            level.playSound(null, blockPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            for (Direction direction : Direction.values()) {
                if (!((Boolean)blockState.getValue((Property)PalladiumDustBlock.getFaceProperty((Direction)direction))).booleanValue()) continue;
                int amount = UniformInt.of((int)8, (int)16).sample(randomSource);
                Vec3 vec3 = new Vec3(direction.step());
                for (int i = 0; i < amount; ++i) {
                    ParticleUtils.spawnParticleOnFace((Level)level, (BlockPos)blockPos, (Direction)direction, (ParticleOptions)ParticleTypes.SMOKE, (Vec3)vec3, (double)0.55);
                }
            }
        }
    }

    private static boolean isWaterThatWouldFlow(BlockPos blockPos, Level level) {
        FluidState fluidState = level.getFluidState(blockPos);
        if (!fluidState.is(FluidTags.WATER)) {
            return false;
        }
        if (fluidState.isSource()) {
            return true;
        }
        float f = fluidState.getAmount();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluidState2 = level.getFluidState(blockPos.below());
        return !fluidState2.is(FluidTags.WATER);
    }

    protected void tick(BlockState blockState, ServerLevel level, BlockPos origin, RandomSource randomSource) {
        if (((Boolean)level.getBlockState(origin).getValue((Property)POWERED)).booleanValue()) {
            this.explode(level, origin);
            level.removeBlock(origin, false);
        }
        for (Direction direction : Direction.values()) {
            BlockPos affectedPosition = origin.relative(direction);
            BlockState relativeState = level.getBlockState(affectedPosition);
            if (relativeState.is((Block)GBlocks.PALLADIUM_DUST.get())) {
                level.setBlock(affectedPosition, (BlockState)relativeState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                level.scheduleTick(affectedPosition, (Block)this, 2);
            }
            for (Direction yDirection : Direction.Plane.VERTICAL) {
                BlockState relativeAboveState = level.getBlockState(affectedPosition.relative(yDirection));
                if (!relativeAboveState.is((Block)GBlocks.PALLADIUM_DUST.get())) continue;
                level.setBlock(affectedPosition.relative(yDirection), (BlockState)relativeAboveState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                level.scheduleTick(affectedPosition.relative(yDirection), (Block)this, 2);
            }
        }
    }

    protected void onExplosionHit(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Explosion explosion, BiConsumer<ItemStack, BlockPos> biConsumer) {
    }

    private void explode(ServerLevel level, final BlockPos origin) {
        boolean bl = Direction.Plane.HORIZONTAL.stream().map(arg_0 -> ((BlockPos)origin).relative(arg_0)).anyMatch(blockPos -> PalladiumDustBlock.isWaterThatWouldFlow(blockPos, (Level)level));
        final boolean bl2 = bl || level.getFluidState(origin.above()).is(FluidTags.WATER);
        ExplosionDamageCalculator explosionDamageCalculator = new ExplosionDamageCalculator(this){

            public boolean shouldBlockExplode(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, float f) {
                if (BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).getPath().contains("ore")) {
                    return false;
                }
                if (!blockState.isAir()) {
                    boolean flag = true;
                    for (Direction direction : Direction.values()) {
                        if (!blockGetter.getBlockState(blockPos.relative(direction)).is((Block)GBlocks.PALLADIUM_DUST.get())) continue;
                        flag = false;
                    }
                    return flag;
                }
                return true;
            }

            public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
                if (blockPos.equals((Object)origin) && bl2) {
                    return Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance()));
                }
                Optional<Float> resistance = super.getBlockExplosionResistance(explosion, blockGetter, blockPos, blockState, fluidState);
                resistance = Optional.of(Float.valueOf(resistance.orElse(Float.valueOf(0.0f)).floatValue() / 2.0f));
                return resistance;
            }
        };
        Vec3 vec3 = origin.getCenter();
        float explosion = 3.0f;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)level.getBlockState(origin).getValue((Property)PalladiumDustBlock.getFaceProperty((Direction)direction))).booleanValue()) continue;
            explosion += 0.2f;
        }
        level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), explosionDamageCalculator, vec3, explosion, false, Level.ExplosionInteraction.BLOCK);
    }

    protected int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected boolean canBeReplaced(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        return blockPlaceContext.getItemInHand().is(((Block)GBlocks.PALLADIUM_DUST.get()).asItem());
    }
}

