/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.blocks.PalladiumLatticeBlock;
import net.orcinus.galosphere.init.GBlocks;

public class PalladiumLatticeVineBlock
extends PalladiumLatticeBlock
implements BonemealableBlock {
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;
    public static final BooleanProperty SPREADABLE = BooleanProperty.create((String)"spreadable");

    public PalladiumLatticeVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false))).setValue((Property)SPREADABLE, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BERRIES, SPREADABLE});
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)BERRIES) == false || (Boolean)blockState.getValue((Property)SPREADABLE) != false;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!((Boolean)blockState.getValue((Property)SPREADABLE)).booleanValue()) {
            return;
        }
        if (randomSource.nextBoolean()) {
            if (((Boolean)blockState.getValue((Property)BERRIES)).booleanValue()) {
                for (Direction direction : Direction.values()) {
                    BlockPos relativePos = blockPos.relative(direction);
                    BlockState relativeState = serverLevel.getBlockState(relativePos);
                    if (!relativeState.is((Block)GBlocks.PALLADIUM_LATTICE.get())) continue;
                    serverLevel.setBlockAndUpdate(relativePos, ((Block)GBlocks.GLOW_BERRIES_PALLADIUM_LATTICE.get()).withPropertiesOf(relativeState));
                    break;
                }
            } else {
                BlockState state = (BlockState)blockState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true));
                serverLevel.setBlockAndUpdate(blockPos, state);
                serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)state));
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return new ItemStack((ItemLike)GBlocks.PALLADIUM_LATTICE.get());
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (itemStack.is(Tags.Items.TOOLS_SHEAR) && ((Boolean)blockState.getValue((Property)SPREADABLE)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockPos, itemStack);
            }
            level.playSound(player, blockPos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)SPREADABLE, (Comparable)Boolean.valueOf(false)));
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            return InteractionResult.SUCCESS;
        }
        if (itemStack.isEmpty()) {
            BlockState lattice = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)GBlocks.PALLADIUM_LATTICE.get()).defaultBlockState().setValue((Property)NORTH, (Comparable)((Boolean)blockState.getValue((Property)NORTH)))).setValue((Property)EAST, (Comparable)((Boolean)blockState.getValue((Property)EAST)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState.getValue((Property)SOUTH)))).setValue((Property)WEST, (Comparable)((Boolean)blockState.getValue((Property)WEST)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)blockState.getValue((Property)WATERLOGGED)));
            if (!player.getInventory().add(new ItemStack((ItemLike)Items.GLOW_BERRIES))) {
                player.drop(new ItemStack((ItemLike)Items.GLOW_BERRIES), false);
            }
            BlockState newState = (Boolean)blockState.getValue((Property)BERRIES) != false ? (BlockState)blockState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)) : lattice;
            level.setBlockAndUpdate(blockPos, newState);
            level.playSound(null, blockPos, SoundEvents.CAVE_VINES_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

