/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GEntityTypes;

public class CordycepsBlockEntity
extends BlockEntity {
    private int growthTick;
    private int delay = 0;

    public CordycepsBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(GBlockEntityTypes.CORDYCEPS.get(), blockPos, blockState);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("GrowthTicks", this.growthTick);
        compoundTag.putInt("Delay", this.delay);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.growthTick = compoundTag.getInt("GrowthTicks");
        this.delay = compoundTag.getInt("Delay");
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CordycepsBlockEntity te) {
        if (!((Boolean)state.getValue((Property)CordycepsBlock.ALIVE)).booleanValue()) {
            return;
        }
        int stage = (Integer)state.getValue((Property)CordycepsBlock.ALIVE_STAGE);
        int delay = te.getDelay();
        if (te.getGrowthTick() >= 6000) {
            Optional.ofNullable((Spectre)GEntityTypes.SPECTRE.get().create(world, EntitySpawnReason.BREEDING)).ifPresent(spectre -> te.spawnSpectre(world, pos, (Spectre)spectre));
        }
        if (delay > 0) {
            te.setDelay(delay - 1);
        }
        if (stage < 5 && delay == 0) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
            te.setDelay(20);
        }
        if (stage == 5) {
            te.setDelay(0);
            if (te.getGrowthTick() < 6000) {
                if (te.getGrowthTick() > 5000) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)CordycepsBlock.BULB, (Comparable)Boolean.valueOf(true)), 2);
                }
                te.setGrowthTick(te.getGrowthTick() + 1);
            }
        }
    }

    private void spawnSpectre(Level world, BlockPos pos, Spectre spectre) {
        spectre.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        spectre.setPersistenceRequired();
        world.addFreshEntity((Entity)spectre);
        world.destroyBlock(pos, true);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setGrowthTick(int growthTick) {
        this.growthTick = growthTick;
    }

    public int getGrowthTick() {
        return this.growthTick;
    }
}

