/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.blocks.MoleBurrowBlock;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.items.components.MoleData;
import net.orcinus.galosphere.util.quests.MiningPouchManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MoleBurrowBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private CustomData data = CustomData.EMPTY;
    @Nullable
    private Rarity rarity = null;
    private int ticks = -1;
    private int maxTicks = 0;
    private int pauseTicks = 0;
    private int spawnCount = 0;

    public MoleBurrowBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(GBlockEntityTypes.MOLE_BURROW.get(), blockPos, blockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.ticks = compoundTag.getInt("Ticks");
        this.maxTicks = compoundTag.getInt("MaxTicks");
        this.pauseTicks = compoundTag.getInt("PauseTicks");
        this.spawnCount = compoundTag.getInt("SpawnCount");
        CustomData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("Mole")).resultOrPartial(string -> LOGGER.error("Failed to parse mole: '{}'", string)).ifPresent(customData -> {
            this.data = customData;
        });
        if (compoundTag.get("Rarity") != null) {
            Rarity.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("Rarity")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setRarity);
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("Ticks", this.ticks);
        compoundTag.putInt("MaxTicks", this.maxTicks);
        compoundTag.putInt("PauseTicks", this.pauseTicks);
        compoundTag.putInt("SpawnCount", this.spawnCount);
        compoundTag.put("Mole", (Tag)CustomData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.data).getOrThrow());
        if (this.rarity != null) {
            compoundTag.put("Rarity", (Tag)Rarity.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getRarity()).getOrThrow());
        }
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    @Nullable
    public Rarity getRarity() {
        return this.rarity;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MoleBurrowBlockEntity entity) {
        MoleBurrowBlockEntity.tickMole(level, blockPos, blockState, entity);
        MoleBurrowBlockEntity.generateRewards(level, blockPos, entity);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void generateRewards(Level level, BlockPos blockPos, MoleBurrowBlockEntity entity) {
        Rarity rarity = entity.getRarity();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (rarity != null && entity.spawnCount < 3) {
                ItemStack itemStack = (ItemStack)MiningPouchManager.getPouchRewards(serverLevel, blockPos, rarity).get(0);
                if (entity.pauseTicks > 0) {
                    --entity.pauseTicks;
                    return;
                }
                DefaultDispenseItemBehavior.spawnItem((Level)level, (ItemStack)itemStack, (int)2, (Direction)Direction.UP, (Position)Vec3.atBottomCenterOf((Vec3i)blockPos).relative(Direction.UP, 1.2));
                level.playSound(null, blockPos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5, 15, 0.0, 0.0, 0.0, 0.0);
                entity.pauseTicks = 20;
                ++entity.spawnCount;
                return;
            }
        }
        entity.rarity = null;
        entity.spawnCount = 0;
    }

    private static void tickMole(Level level, BlockPos blockPos, BlockState blockState, MoleBurrowBlockEntity entity) {
        if (!entity.isEmpty()) {
            if (entity.ticks < entity.maxTicks) {
                ++entity.ticks;
                if (level.getRandom().nextDouble() < 0.005) {
                    level.playSound(null, (double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, SoundEvents.BEEHIVE_WORK, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                MoleBurrowBlockEntity.releaseMole(level, blockPos, blockState, entity.data.copyTag(), MoleReleaseStatus.MOLE_RELEASED);
                entity.ticks = -1;
                entity.maxTicks = -1;
                entity.data = CustomData.EMPTY;
                MoleBurrowBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        }
    }

    private static boolean releaseMole(Level level, BlockPos blockPos, BlockState blockState, CompoundTag compoundTag, MoleReleaseStatus moleReleaseStatus) {
        boolean bl;
        BlockPos blockPos3 = blockPos.above();
        boolean bl2 = bl = !level.getBlockState(blockPos3).getCollisionShape((BlockGetter)level, blockPos3).isEmpty();
        if (bl && moleReleaseStatus != MoleReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)level, (EntitySpawnReason)EntitySpawnReason.TRIGGERED, e -> e);
        if (entity != null) {
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)level.getBlockState(blockPos)));
            if (entity instanceof Mole) {
                Mole mole = (Mole)entity;
                double e2 = (double)blockPos.getX() + 0.5;
                double g = (double)blockPos.getY() + 1.0;
                double h = (double)blockPos.getZ() + 0.5;
                mole.moveTo(e2, g, h, mole.getYRot(), mole.getXRot());
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    mole.getType().spawn(serverLevel, null, null, blockPos, EntitySpawnReason.TRIGGERED, true, false);
                }
            }
            return true;
        }
        return false;
    }

    public void releaseAllOccupants(BlockState blockState, MoleReleaseStatus moleReleaseStatus) {
        if (this.isEmpty()) {
            return;
        }
        MoleBurrowBlockEntity.releaseMole(this.level, this.worldPosition, blockState, this.data.copyTag(), moleReleaseStatus);
        super.setChanged();
    }

    public void addMole(Entity entity) {
        this.addMole(entity, true);
    }

    public void addMole(Entity entity, boolean pouch) {
        if (!this.isEmpty()) {
            return;
        }
        entity.stopRiding();
        entity.ejectPassengers();
        this.storeMole(entity, pouch);
        entity.discard();
        super.setChanged();
    }

    private void storeMole(Entity entity, boolean pouch) {
        CompoundTag compoundTag = new CompoundTag();
        entity.save(compoundTag);
        if (this.level != null) {
            BlockPos blockPos = this.getBlockPos();
            BlockState state = this.getBlockState();
            int pouches = pouch ? Math.min(3, (Integer)state.getValue((Property)MoleBurrowBlock.POUCHES) + 1) : 0;
            this.level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)MoleBurrowBlock.POUCHES, (Comparable)Integer.valueOf(pouches)));
            this.level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
        }
        this.data = CustomData.of((CompoundTag)compoundTag);
        this.ticks = 0;
        this.maxTicks = 600;
    }

    public boolean isEmpty() {
        return this.data == CustomData.EMPTY;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.data = ((MoleData)componentInput.getOrDefault(GDataComponents.MOLE.get(), (Object)MoleData.EMPTY)).moleData();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(GDataComponents.MOLE.get(), (Object)new MoleData(this.data));
    }

    public void removeComponentsFromTag(CompoundTag compoundTag) {
        super.removeComponentsFromTag(compoundTag);
        compoundTag.remove("Mole");
    }

    public static enum MoleReleaseStatus {
        ITEM_DELIVERED,
        MOLE_RELEASED,
        EMERGENCY;

    }
}

