/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.ShadowFrameBlock;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class ShadowFrameBlockEntity
extends BlockEntity {
    private boolean isWaxed;
    private BlockState copiedState = Blocks.AIR.defaultBlockState();

    public ShadowFrameBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(GBlockEntityTypes.SHADOW_FRAME.get(), blockPos, blockState);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        DefaultedRegistry holderGetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK;
        this.copiedState = NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)compoundTag.getCompound("CopiedState"));
        this.isWaxed = compoundTag.getBoolean("is_waxed");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("CopiedState", (Tag)NbtUtils.writeBlockState((BlockState)this.copiedState));
        compoundTag.putBoolean("is_waxed", this.isWaxed);
    }

    public BlockState getCopiedState() {
        return this.copiedState;
    }

    public void setCopiedState(BlockState copiedState) {
        this.copiedState = copiedState;
    }

    public void interact(BlockState copiedState, Level level, BlockPos blockPos, BlockState blockState) {
        this.setCopiedState(copiedState);
        int light = 0;
        if (copiedState.getLightEmission() > 0) {
            light = Math.min(15, copiedState.getLightEmission());
        }
        level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)ShadowFrameBlock.FILLED, (Comparable)Boolean.valueOf(true))).setValue((Property)ShadowFrameBlock.LEVEL, (Comparable)Integer.valueOf(light)), 2);
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

