/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.animations.MoleAnimations;
import net.orcinus.galosphere.client.renderer.entity.state.MoleRenderState;

@OnlyIn(value=Dist.CLIENT)
public class MoleModel
extends EntityModel<MoleRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.5f);

    public MoleModel(ModelPart root) {
        super(root.getChild("root"));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(6, 32).addBox(-5.5f, -6.0f, -10.9f, 11.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.5f, -12.0f, -11.0f, 13.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)4.0f));
        PartDefinition leftBottomWhisker = body.addOrReplaceChild("leftBottomWhisker", CubeListBuilder.create().texOffs(0, 37).addBox(0.0f, -0.5f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)-4.5f, (float)-11.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightBottomWhisker = body.addOrReplaceChild("rightBottomWhisker", CubeListBuilder.create().texOffs(0, 37).mirror().addBox(-8.0f, -0.5f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.5f, (float)-4.5f, (float)-11.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftTopWhisker = body.addOrReplaceChild("leftTopWhisker", CubeListBuilder.create().texOffs(16, 37).addBox(0.0f, -2.5f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)-6.5f, (float)-11.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightTopWhisker = body.addOrReplaceChild("rightTopWhisker", CubeListBuilder.create().texOffs(16, 37).mirror().addBox(-8.0f, -2.5f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.5f, (float)-6.5f, (float)-11.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition nose = body.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 40).addBox(-3.5f, -4.0f, 0.0f, 7.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-11.5f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(34, 26).addBox(-1.5f, 0.0f, -4.5f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)-9.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(34, 26).mirror().addBox(-1.5f, 0.0f, -4.5f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)-9.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(34, 26).addBox(-1.5f, 0.0f, -4.5f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-2.0f, (float)5.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightLeg = root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(34, 26).mirror().addBox(-1.5f, 0.0f, -4.5f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)-2.0f, (float)5.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(MoleRenderState moleRenderState) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float ageInTicks = moleRenderState.ageInTicks;
        this.animateWalk(MoleAnimations.MOLE_WALK, moleRenderState.walkAnimationPos, moleRenderState.walkAnimationSpeed, 2.0f, 2.5f);
        this.animate(moleRenderState.sniffAnimationState, MoleAnimations.MOLE_SNIFF, ageInTicks, 1.0f);
        this.animate(moleRenderState.twitchAnimationState, MoleAnimations.MOLE_TWITCH, ageInTicks, 1.0f);
        this.animate(moleRenderState.diggingAnimationState, MoleAnimations.MOLE_DIG, ageInTicks, 1.0f);
        this.animate(moleRenderState.emergeAnimationState, MoleAnimations.MOLE_DIG_UP, ageInTicks, 1.0f);
    }
}

