/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.client.renderer.entity.state.SpectreRenderState;

@OnlyIn(value=Dist.CLIENT)
public class SpectreModel
extends EntityModel<SpectreRenderState> {
    private final ModelPart head;
    private final ModelPart body;

    public SpectreModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)1.0f));
        PartDefinition leftAntenna = head.addOrReplaceChild("leftAntenna", CubeListBuilder.create().texOffs(6, 10).addBox(0.0f, -1.5f, -3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-3.5f, (float)-3.0f));
        PartDefinition rightAntenna = head.addOrReplaceChild("rightAntenna", CubeListBuilder.create().texOffs(6, 10).mirror().addBox(0.0f, -1.5f, -3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)-3.5f, (float)-3.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.5f, (float)0.5f));
        PartDefinition topLegs = body.addOrReplaceChild("topLegs", CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition bottomLegs = body.addOrReplaceChild("bottomLegs", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(14, 8).addBox(0.0f, -4.0f, 0.0f, 9.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)1.0f, (float)0.5f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(14, 8).mirror().addBox(-9.0f, -4.0f, 0.0f, 9.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)0.5f, (float)0.0f, (float)1.0472f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void setupAnim(SpectreRenderState spectreRenderState) {
        super.setupAnim((EntityRenderState)spectreRenderState);
        float speed = 1.5f;
        float degree = 1.5f;
        float ageInTicks = spectreRenderState.ageInTicks;
        float tilt = Math.min(spectreRenderState.walkAnimationSpeed / 0.3f, 1.0f);
        this.body.xRot = tilt * 0.5f;
        this.body.xRot += Mth.cos((float)(ageInTicks * 0.2f)) * 0.15f;
        this.head.getChild((String)"leftAntenna").xRot = -(Mth.cos((float)(ageInTicks * 0.2f)) * 0.25f);
        this.head.getChild((String)"rightAntenna").xRot = -(Mth.sin((float)(ageInTicks * 0.2f)) * 0.25f);
        this.body.getChild((String)"rightWing").yRot = -(Mth.cos((float)(ageInTicks * speed * 0.8f)) * degree * 2.0f * 0.25f - 1.0f);
        this.body.getChild((String)"leftWing").yRot = -this.body.getChild((String)"rightWing").yRot;
    }
}

