/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.BerserkerModel;
import net.orcinus.galosphere.client.renderer.entity.state.BerserkerRenderState;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class BerserkerRenderer
extends MobRenderer<Berserker, BerserkerRenderState, BerserkerModel> {
    private static final Map<Integer, ResourceLocation> TEXTURES = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(0, Galosphere.id("textures/entity/berserker/berserker.png"));
        map.put(1, Galosphere.id("textures/entity/berserker/half_damaged_berserker.png"));
        map.put(2, Galosphere.id("textures/entity/berserker/high_damaged_berserker.png"));
        map.put(3, Galosphere.id("textures/entity/berserker/stationary_berserker.png"));
    });

    public BerserkerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BerserkerModel(context.bakeLayer(GModelLayers.BERSERKER)), 0.9f);
    }

    public BerserkerRenderState createRenderState() {
        return new BerserkerRenderState();
    }

    protected boolean isShaking(BerserkerRenderState livingEntityRenderState) {
        return livingEntityRenderState.shedding;
    }

    public ResourceLocation getTextureLocation(BerserkerRenderState livingEntityRenderState) {
        return TEXTURES.get(livingEntityRenderState.stage);
    }

    public void extractRenderState(Berserker livingEntity, BerserkerRenderState livingEntityRenderState, float f) {
        super.extractRenderState((LivingEntity)livingEntity, (LivingEntityRenderState)livingEntityRenderState, f);
        livingEntityRenderState.stage = livingEntity.getStage();
        livingEntityRenderState.shedding = livingEntity.isShedding();
        livingEntityRenderState.attackAnimationState = livingEntity.attackAnimationState;
        livingEntityRenderState.impalingAnimationState = livingEntity.impalingAnimationState;
        livingEntityRenderState.roarAnimationState = livingEntity.roarAnimationState;
        livingEntityRenderState.punchAnimationState = livingEntity.punchAnimationState;
        livingEntityRenderState.summoningAnimationState = livingEntity.summoningAnimationState;
        livingEntityRenderState.salifyingAnimationState = livingEntity.salifyingAnimationState;
    }
}

