/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.MoleModel;
import net.orcinus.galosphere.client.renderer.entity.state.MoleRenderState;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class MoleRenderer
extends AgeableMobRenderer<Mole, MoleRenderState, MoleModel> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/mole/mole.png");

    public MoleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MoleModel(context.bakeLayer(GModelLayers.MOLE)), (EntityModel)new MoleModel(context.bakeLayer(GModelLayers.MOLE_BABY)), 0.6f);
    }

    public MoleRenderState createRenderState() {
        return new MoleRenderState();
    }

    public ResourceLocation getTextureLocation(MoleRenderState livingEntityRenderState) {
        return TEXTURE;
    }

    public void extractRenderState(Mole livingEntity, MoleRenderState livingEntityRenderState, float f) {
        super.extractRenderState((LivingEntity)livingEntity, (LivingEntityRenderState)livingEntityRenderState, f);
        livingEntityRenderState.sniffAnimationState = livingEntity.sniffAnimationState;
        livingEntityRenderState.twitchAnimationState = livingEntity.twitchAnimationState;
        livingEntityRenderState.diggingAnimationState = livingEntity.diggingAnimationState;
        livingEntityRenderState.emergeAnimationState = livingEntity.emergeAnimationState;
    }

    public void render(MoleRenderState livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        float size = livingEntityRenderState.isBaby ? 0.5f : 1.0f;
        poseStack.scale(size, size, size);
        super.render((LivingEntityRenderState)livingEntityRenderState, poseStack, multiBufferSource, i);
        poseStack.popPose();
    }
}

