/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.PinkSaltPillarModel;
import net.orcinus.galosphere.client.renderer.entity.state.PinkSaltPillarRenderState;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class PinkSaltPillarRenderer
extends EntityRenderer<PinkSaltPillar, PinkSaltPillarRenderState> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/pink_salt_pillar/pink_salt_pillar.png");
    private final PinkSaltPillarModel model;

    public PinkSaltPillarRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PinkSaltPillarModel(context.bakeLayer(GModelLayers.PINK_SALT_PILLAR));
    }

    public PinkSaltPillarRenderState createRenderState() {
        return new PinkSaltPillarRenderState();
    }

    public void render(PinkSaltPillarRenderState entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        if (!entityRenderState.active) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.0f, 0.0f);
        this.model.setupAnim(entityRenderState);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.model.renderType(TEXTURE));
        this.model.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)entityRenderState, poseStack, multiBufferSource, i);
    }

    public void extractRenderState(PinkSaltPillar entity, PinkSaltPillarRenderState entityRenderState, float f) {
        entityRenderState.emergeAnimationState = entity.emergeAnimationState;
        entityRenderState.retractAnimationState = entity.retractAnimationState;
        entityRenderState.active = entity.isActive();
        super.extractRenderState((Entity)entity, (EntityRenderState)entityRenderState, f);
    }
}

