/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.renderer.entity.state.SpectatorVisionRenderState;
import net.orcinus.galosphere.entities.SpectatorVision;

@OnlyIn(value=Dist.CLIENT)
public class SpectatorVisionRenderer
extends EntityRenderer<SpectatorVision, SpectatorVisionRenderState> {
    private static final Function<Integer, ResourceLocation> FUNCTION = integer -> Galosphere.id("textures/entity/spectator_vision/spectator_vision_" + integer + ".png");

    public SpectatorVisionRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpectatorVisionRenderState entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        float size = 1.5f;
        float sin = Mth.sin((float)(entityRenderState.ageInTicks / 4.0f)) / 16.0f;
        poseStack.scale(size, size, size);
        poseStack.translate(0.0f, sin, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)FUNCTION.apply(entityRenderState.phase + 1)));
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, i, 0.0f, 0, 0, 1);
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, i, 1.0f, 0, 1, 1);
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, i, 1.0f, 1, 1, 0);
        SpectatorVisionRenderer.vertex(vertexConsumer, pose, i, 0.0f, 1, 0, 0);
        poseStack.popPose();
        super.render((EntityRenderState)entityRenderState, poseStack, multiBufferSource, i);
    }

    protected int getBlockLightLevel(SpectatorVision entity, BlockPos blockPos) {
        return entity.getPhase();
    }

    public SpectatorVisionRenderState createRenderState() {
        return new SpectatorVisionRenderState();
    }

    public void extractRenderState(SpectatorVision entity, SpectatorVisionRenderState entityRenderState, float f) {
        super.extractRenderState((Entity)entity, (EntityRenderState)entityRenderState, f);
        entityRenderState.phase = entity.getPhase();
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, int i, float f, int j, int k, int l) {
        vertexConsumer.addVertex(pose, f - 0.5f, (float)j - 0.5f, 0.0f).setColor(-1).setUv((float)k, (float)l).setOverlay(OverlayTexture.NO_OVERLAY).setLight(i).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

