/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.List;
import java.util.Set;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.orcinus.galosphere.blocks.MoleBurrowBlock;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;

public class GBlockLootTables
extends BlockLootSubProvider {
    public GBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        HolderLookup.RegistryLookup registryLookup2 = this.registries.lookupOrThrow(Registries.ITEM);
        this.add((Block)GBlocks.MOLE_BURROW.get(), block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(GDataComponents.MOLE.get())).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy((Property)MoleBurrowBlock.POUCHES)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)))));
        this.dropSelf((Block)GBlocks.LICHEN_VINES.get());
        this.dropSelf((Block)GBlocks.OPAL_SAPLING.get());
        this.dropPottedContents((Block)GBlocks.POTTED_OPAL_SAPLING.get());
        this.add((Block)GBlocks.PALLADIUM_ORE.get(), block -> this.createOreDrop((Block)block, (Item)GItems.RAW_PALLADIUM.get()));
        this.add((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get(), block -> this.createOreDrop((Block)block, (Item)GItems.RAW_PALLADIUM.get()));
        this.dropSelf((Block)GBlocks.TUFF_DIRT.get());
        this.add((Block)GBlocks.PALLADIUM_DUST.get(), block -> this.createMultifaceBlockDrops((Block)GBlocks.PALLADIUM_DUST.get()));
        this.dropSelf((Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get());
        this.dropSelf((Block)GBlocks.LUMIERE_BLOCK.get());
        this.dropSelf((Block)GBlocks.ALLURITE_BLOCK.get());
        this.dropSelf((Block)GBlocks.RAW_PALLADIUM_BLOCK.get());
        this.dropSelf((Block)GBlocks.PALLADIUM_BLOCK.get());
        this.dropSelf((Block)GBlocks.AMETHYST_STAIRS.get());
        this.dropSlab((Block)GBlocks.AMETHYST_SLAB.get());
        this.dropSelf((Block)GBlocks.ALLURITE_STAIRS.get());
        this.dropSlab((Block)GBlocks.ALLURITE_SLAB.get());
        this.dropSelf((Block)GBlocks.LUMIERE_STAIRS.get());
        this.dropSlab((Block)GBlocks.LUMIERE_SLAB.get());
        this.dropSelf((Block)GBlocks.SMOOTH_AMETHYST.get());
        this.dropSelf((Block)GBlocks.SMOOTH_AMETHYST_STAIRS.get());
        this.dropSlab((Block)GBlocks.SMOOTH_AMETHYST_SLAB.get());
        this.dropSelf((Block)GBlocks.AMETHYST_BRICKS.get());
        this.dropSelf((Block)GBlocks.AMETHYST_BRICK_STAIRS.get());
        this.dropSlab((Block)GBlocks.AMETHYST_BRICK_SLAB.get());
        this.dropSelf((Block)GBlocks.CHISELED_AMETHYST.get());
        this.add((Block)GBlocks.ALLURITE_CLUSTER.get(), block -> GBlockLootTables.dropAlternativeWithSilkTouch(block, (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get(), ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.ALLURITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registryLookup2, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.ALLURITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))), this.registries));
        this.add((Block)GBlocks.LUMIERE_CLUSTER.get(), block -> GBlockLootTables.dropAlternativeWithSilkTouch(block, (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get(), ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registryLookup2, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))), this.registries));
        this.add((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.ALLURITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registryLookup2, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.ALLURITE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.add((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registryLookup2, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.add((Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registryLookup2, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.AMETHYST_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.dropSelf((Block)GBlocks.LUMIERE_LAMP.get());
        this.dropSelf((Block)GBlocks.ALLURITE_LAMP.get());
        this.dropSelf((Block)GBlocks.AMETHYST_LAMP.get());
        this.dropOther((Block)GBlocks.LUMIERE_COMPOSTER.get(), (ItemLike)Blocks.COMPOSTER);
        this.dropOther((Block)GBlocks.SALINE_COMPOSTER.get(), (ItemLike)Blocks.COMPOSTER);
        this.dropSelf((Block)GBlocks.COMBUSTION_TABLE.get());
        this.dropSelf((Block)GBlocks.SMOOTH_ALLURITE.get());
        this.dropSlab((Block)GBlocks.SMOOTH_ALLURITE_SLAB.get());
        this.dropSelf((Block)GBlocks.SMOOTH_ALLURITE_STAIRS.get());
        this.dropSelf((Block)GBlocks.ALLURITE_BRICKS.get());
        this.dropSelf((Block)GBlocks.CHISELED_ALLURITE.get());
        this.dropSelf((Block)GBlocks.SMOOTH_LUMIERE.get());
        this.dropSlab((Block)GBlocks.SMOOTH_LUMIERE_SLAB.get());
        this.dropSelf((Block)GBlocks.SMOOTH_LUMIERE_STAIRS.get());
        this.dropSelf((Block)GBlocks.LUMIERE_BRICKS.get());
        this.dropSelf((Block)GBlocks.CHISELED_LUMIERE.get());
        this.dropSelf((Block)GBlocks.ALLURITE_BRICK_STAIRS.get());
        this.dropSlab((Block)GBlocks.ALLURITE_BRICK_SLAB.get());
        this.dropSelf((Block)GBlocks.LUMIERE_BRICK_STAIRS.get());
        this.dropSlab((Block)GBlocks.LUMIERE_BRICK_SLAB.get());
        this.dropSelf((Block)GBlocks.LICHEN_MOSS.get());
        this.dropSelf((Block)GBlocks.LICHEN_ROOTS.get());
        this.dropSelf((Block)GBlocks.LICHEN_SHELF.get());
        this.dropSelf((Block)GBlocks.BOWL_LICHEN.get());
        this.dropSelf((Block)GBlocks.CHANDELIER.get());
        this.dropSelf((Block)GBlocks.SOUL_CHANDELIER.get());
        this.addVinesDroptable((Block)GBlocks.LICHEN_CORDYCEPS.get(), (Block)GBlocks.LICHEN_CORDYCEPS_PLANT.get(), (HolderLookup.RegistryLookup<Enchantment>)registryLookup);
        this.add((Block)GBlocks.GLOW_INK_CLUMPS.get(), block -> this.createMultifaceBlockDrops((Block)block, Items.GLOW_INK_SAC));
        this.dropPottedContents((Block)GBlocks.POTTED_BOWL_LICHEN.get());
        this.dropPottedContents((Block)GBlocks.POTTED_LICHEN_ROOTS.get());
        this.dropSelf((Block)GBlocks.PALLADIUM_TILES.get());
        this.dropSelf((Block)GBlocks.PALLADIUM_TILES_STAIRS.get());
        this.dropSlab((Block)GBlocks.PALLADIUM_TILES_SLAB.get());
        this.dropSelf((Block)GBlocks.PALLADIUM_PANEL.get());
        this.dropSelf((Block)GBlocks.PALLADIUM_PANEL_STAIRS.get());
        this.dropSlab((Block)GBlocks.PALLADIUM_PANEL_SLAB.get());
        this.dropSelf((Block)GBlocks.PALLADIUM_LATTICE.get());
        this.dropOther((Block)GBlocks.GLOW_BERRIES_PALLADIUM_LATTICE.get(), (ItemLike)GBlocks.PALLADIUM_LATTICE.get());
        this.add((Block)GBlocks.LIGHT_STAND.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add((Block)GBlocks.SOUL_LIGHT_STAND.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf((Block)GBlocks.PINK_SALT.get());
        this.dropSelf((Block)GBlocks.ROSE_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.PASTEL_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.POLISHED_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.PINK_SALT_BRICKS.get());
        this.dropSelf((Block)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.dropSelf((Block)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.dropSlab((Block)GBlocks.PINK_SALT_SLAB.get());
        this.dropSlab((Block)GBlocks.ROSE_PINK_SALT_SLAB.get());
        this.dropSlab((Block)GBlocks.PASTEL_PINK_SALT_SLAB.get());
        this.dropSlab((Block)GBlocks.POLISHED_PINK_SALT_SLAB.get());
        this.dropSlab((Block)GBlocks.POLISHED_ROSE_PINK_SALT_SLAB.get());
        this.dropSlab((Block)GBlocks.POLISHED_PASTEL_PINK_SALT_SLAB.get());
        this.dropSlab((Block)GBlocks.PINK_SALT_BRICK_SLAB.get());
        this.dropSlab((Block)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get());
        this.dropSlab((Block)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get());
        this.dropSelf((Block)GBlocks.PINK_SALT_STAIRS.get());
        this.dropSelf((Block)GBlocks.ROSE_PINK_SALT_STAIRS.get());
        this.dropSelf((Block)GBlocks.PASTEL_PINK_SALT_STAIRS.get());
        this.dropSelf((Block)GBlocks.POLISHED_PINK_SALT_STAIRS.get());
        this.dropSelf((Block)GBlocks.POLISHED_ROSE_PINK_SALT_STAIRS.get());
        this.dropSelf((Block)GBlocks.POLISHED_PASTEL_PINK_SALT_STAIRS.get());
        this.dropSelf((Block)GBlocks.PINK_SALT_BRICK_STAIRS.get());
        this.dropSelf((Block)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get());
        this.dropSelf((Block)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get());
        this.dropSelf((Block)GBlocks.PINK_SALT_WALL.get());
        this.dropSelf((Block)GBlocks.ROSE_PINK_SALT_WALL.get());
        this.dropSelf((Block)GBlocks.PASTEL_PINK_SALT_WALL.get());
        this.dropSelf((Block)GBlocks.POLISHED_PINK_SALT_WALL.get());
        this.dropSelf((Block)GBlocks.POLISHED_ROSE_PINK_SALT_WALL.get());
        this.dropSelf((Block)GBlocks.POLISHED_PASTEL_PINK_SALT_WALL.get());
        this.dropSelf((Block)GBlocks.PINK_SALT_BRICK_WALL.get());
        this.dropSelf((Block)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get());
        this.dropSelf((Block)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get());
        this.dropSelf((Block)GBlocks.CHISELED_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.CHISELED_ROSE_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.CHISELED_PASTEL_PINK_SALT.get());
        this.dropSelf((Block)GBlocks.SHADOW_FRAME.get());
        this.dropSelf((Block)GBlocks.PINK_SALT_LAMP.get());
        this.add((Block)GBlocks.PINK_SALT_STRAW.get(), block -> this.createSilkTouchDispatchTable((Block)block, LootItem.lootTableItem((ItemLike)((Block)GBlocks.PINK_SALT_STRAW.get()).asItem()).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.1f, 0.14285715f, 0.25f, 1.0f}))));
        this.dropSelf((Block)GBlocks.CURED_MEMBRANE_BLOCK.get());
        this.add((Block)GBlocks.PINK_SALT_CLUSTER.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem(GItems.PINK_SALT_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registryLookup2, ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem(GItems.PINK_SALT_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        this.dropSelf((Block)GBlocks.GILDED_BEADS.get());
        this.dropSelf((Block)GBlocks.OPAL_LOG.get());
        this.dropSelf((Block)GBlocks.OPAL_BRICKS.get());
        this.dropSelf((Block)GBlocks.BURROW_ANCHOR.get());
        this.dropSelf((Block)GBlocks.OPAL_LOG.get());
        this.add((Block)GBlocks.OPAL_LEAVES.get(), block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)GBlocks.OPAL_LEAVES.get())).when(GBlockLootTables.containsSilkTouch(this.registries))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem(GItems.OPAL)))));
        this.dropSelf((Block)GBlocks.OPAL_BLOCK.get());
        this.dropSelf((Block)GBlocks.OPAL_BRICKS.get());
        this.dropSlab((Block)GBlocks.OPAL_BRICK_SLAB.get());
        this.dropSelf((Block)GBlocks.OPAL_BRICK_STAIRS.get());
        this.dropSelf((Block)GBlocks.OPAL_BRICK_WALL.get());
        this.dropSelf((Block)GBlocks.CHISELED_OPAL_BRICKS.get());
    }

    protected LootTable.Builder createMoleBurrowDrop(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(GDataComponents.MOLE.get())).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy((Property)MoleBurrowBlock.POUCHES)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
    }

    private static LootItemCondition.Builder containsSilkTouch(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup registryLookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registryLookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    protected static LootTable.Builder dropAlternativeWithSilkTouch(Block block, Block alternative, LootPoolEntryContainer.Builder<?> builder, HolderLookup.Provider registries) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)alternative).when(GBlockLootTables.containsSilkTouch(registries))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PollinatedClusterBlock.POLLINATED, true)))).otherwise(LootItem.lootTableItem((ItemLike)block).when(GBlockLootTables.containsSilkTouch(registries))).otherwise(builder));
        return LootTable.lootTable().withPool(lootPool);
    }

    public LootTable.Builder createMultifaceBlockDrops(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((Object[])Direction.values(), direction -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MultifaceBlock.getFaceProperty((Direction)direction), true))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)-1.0f), (boolean)true)))));
    }

    public LootTable.Builder createMultifaceBlockDrops(Block block, Item item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.NATURAL, true)))).apply((Object[])Direction.values(), direction -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MultifaceBlock.getFaceProperty((Direction)direction), true))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)-1.0f), (boolean)true)))));
    }

    private void addVinesDroptable(Block block, Block plantBlock, HolderLookup.RegistryLookup<Enchantment> registryLookup) {
        LootTable.Builder builder = this.createSilkTouchOrShearsDispatchTable(block, LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f})));
        this.add(block, builder);
        this.add(plantBlock, builder);
    }

    private void dropSlab(Block slab) {
        this.add(slab, x$0 -> this.createSlabItemTable((Block)x$0));
    }

    protected Iterable<Block> getKnownBlocks() {
        return GBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

