/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.function.Function;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.Condition;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.blocks.MoleBurrowBlock;
import net.orcinus.galosphere.blocks.PinkSaltStrawBlock;
import net.orcinus.galosphere.init.GBlockFamilies;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GModelTemplates;
import net.orcinus.galosphere.items.properties.Cooldown;
import net.orcinus.galosphere.items.properties.MiningPouchFilled;
import net.orcinus.galosphere.items.properties.MonstrometerFueled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GModelProvider
extends ModelProvider {
    @Nullable
    private Variant lightStandTop = null;
    @Nullable
    private Variant lightStandBottom = null;

    public GModelProvider(PackOutput packOutput) {
        super(packOutput, "galosphere");
    }

    protected void registerModels(BlockModelGenerators blockModelGenerators, ItemModelGenerators itemModelGenerators) {
        GBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(family -> blockModelGenerators.family(family.getBaseBlock()).generateFor(family));
        this.createChiseledPinkSalt(blockModelGenerators, GBlocks.POLISHED_PINK_SALT, GBlocks.CHISELED_PINK_SALT);
        this.createChiseledPinkSalt(blockModelGenerators, GBlocks.POLISHED_ROSE_PINK_SALT, GBlocks.CHISELED_ROSE_PINK_SALT);
        this.createChiseledPinkSalt(blockModelGenerators, GBlocks.POLISHED_PASTEL_PINK_SALT, GBlocks.CHISELED_PASTEL_PINK_SALT);
        blockModelGenerators.createTrivialCube((Block)GBlocks.OPAL_BLOCK.get());
        blockModelGenerators.createTrivialBlock((Block)GBlocks.OPAL_LEAVES.get(), TexturedModel.LEAVES);
        blockModelGenerators.woodProvider((Block)GBlocks.OPAL_LOG.get()).logWithHorizontal((Block)GBlocks.OPAL_LOG.get());
        blockModelGenerators.createPlantWithDefaultItem((Block)GBlocks.OPAL_SAPLING.get(), (Block)GBlocks.POTTED_OPAL_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        GModelProvider.createLichenShelf(blockModelGenerators);
        GModelProvider.createCordyceps(blockModelGenerators);
        GModelProvider.createLichenVines(blockModelGenerators);
        GModelProvider.createChandelier(blockModelGenerators, (Block)GBlocks.CHANDELIER.get());
        GModelProvider.createChandelier(blockModelGenerators, (Block)GBlocks.SOUL_CHANDELIER.get());
        GModelProvider.createPalladiumLattice(blockModelGenerators, GBlocks.PALLADIUM_LATTICE);
        GModelProvider.createPalladiumLattice(blockModelGenerators, GBlocks.GLOW_BERRIES_PALLADIUM_LATTICE);
        GModelProvider.createFilledComposter(blockModelGenerators, GBlocks.LUMIERE_COMPOSTER);
        GModelProvider.createFilledComposter(blockModelGenerators, GBlocks.SALINE_COMPOSTER);
        this.createLightStand(blockModelGenerators, GBlocks.LIGHT_STAND);
        this.createLightStand(blockModelGenerators, GBlocks.SOUL_LIGHT_STAND);
        GModelProvider.createMoleBurrow(blockModelGenerators);
        blockModelGenerators.createTrivialCube((Block)GBlocks.TUFF_DIRT.get());
        blockModelGenerators.createMultiface((Block)GBlocks.GLOW_INK_CLUMPS.get());
        blockModelGenerators.createMultifaceBlockStates((Block)GBlocks.PALLADIUM_DUST.get());
        blockModelGenerators.registerSimpleFlatItemModel(((Block)GBlocks.PALLADIUM_DUST.get()).asItem());
        blockModelGenerators.createTrivialCube((Block)GBlocks.AMETHYST_LAMP.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.ALLURITE_LAMP.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.LUMIERE_LAMP.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.RAW_PALLADIUM_BLOCK.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.PALLADIUM_BLOCK.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.PALLADIUM_ORE.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get());
        GModelProvider.createLichenMoss(blockModelGenerators);
        blockModelGenerators.createPlantWithDefaultItem((Block)GBlocks.LICHEN_ROOTS.get(), (Block)GBlocks.POTTED_LICHEN_ROOTS.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockModelGenerators.createPlantWithDefaultItem((Block)GBlocks.BOWL_LICHEN.get(), (Block)GBlocks.POTTED_BOWL_LICHEN.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        GModelProvider.createCombustionTable(blockModelGenerators);
        GModelProvider.createBurrowAnchor(blockModelGenerators);
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.ALLURITE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.LUMIERE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
        this.createPollinatedCluster(blockModelGenerators, (Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get());
        blockModelGenerators.createTrivialCube((Block)GBlocks.CURED_MEMBRANE_BLOCK.get());
        GModelProvider.createShadowFrame(blockModelGenerators);
        GModelProvider.createStrandedMembrane(blockModelGenerators);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)GBlocks.GILDED_BEADS.get()), (ResourceLocation)blockModelGenerators.createParticleOnlyBlockModel((Block)GBlocks.GILDED_BEADS.get(), Blocks.GOLD_BLOCK)));
        GModelProvider.createPinkSaltStraw(blockModelGenerators);
        GModelProvider.createPinkSaltCluster(blockModelGenerators);
        GModelProvider.createPinkSaltLamp(blockModelGenerators);
        this.generateItemModels(itemModelGenerators);
    }

    private static void createMoleBurrow(BlockModelGenerators blockModelGenerators) {
        blockModelGenerators.registerSimpleItemModel((Block)GBlocks.MOLE_BURROW.get(), ModelLocationUtils.getModelLocation((Block)((Block)GBlocks.MOLE_BURROW.get()), (String)"_top_pouch_0"));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.MOLE_BURROW.get())).with(PropertyDispatch.property((Property)MoleBurrowBlock.POUCHES).generate(integer -> Variant.variant().with(VariantProperties.MODEL, (Object)blockModelGenerators.createSuffixedVariant((Block)GBlocks.MOLE_BURROW.get(), "_top_pouch_" + integer, ModelTemplates.CUBE_TOP, resourceLocation -> {
            Object suffix = integer == 0 ? "_top" : "_top_pouch_" + integer;
            return new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)GBlocks.MOLE_BURROW.get()), (String)suffix)).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.MOLE_BURROW.get()), (String)"_side"));
        })))));
    }

    private static void createCordyceps(BlockModelGenerators blockModelGenerators) {
        ResourceLocation bulbTexture = blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_CORDYCEPS.get(), "_bulb", ModelTemplates.CROSS, TextureMapping::cross);
        ResourceLocation cordyceps = blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_CORDYCEPS.get(), "", ModelTemplates.CROSS, TextureMapping::cross);
        Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)cordyceps);
        Function<Integer, Variant> function = integer -> Variant.variant().with(VariantProperties.MODEL, (Object)blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_CORDYCEPS.get(), "_alive_stage_" + integer, ModelTemplates.CROSS, TextureMapping::cross));
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)GBlocks.LICHEN_CORDYCEPS.get())).with((Condition)Condition.condition().term((Property)CordycepsBlock.BULB, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)bulbTexture)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(0)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(0)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(1)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(1)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(2)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(2)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(3)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(3)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(4)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(4)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(5)).term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), function.apply(5)).with((Condition)Condition.condition().term((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(false)), variant));
        blockModelGenerators.createCrossBlock((Block)GBlocks.LICHEN_CORDYCEPS_PLANT.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockModelGenerators.registerSimpleFlatItemModel(((Block)GBlocks.LICHEN_CORDYCEPS.get()).asItem());
    }

    private static void createPinkSaltLamp(BlockModelGenerators blockModelGenerators) {
        Variant multivariant = Variant.variant().with(VariantProperties.MODEL, (Object)GModelTemplates.PINK_SALT_LAMP.create((Block)GBlocks.PINK_SALT_LAMP.get(), TextureMapping.defaultTexture((Block)((Block)GBlocks.PINK_SALT_LAMP.get())), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.PINK_SALT_LAMP.get()), (Variant)multivariant).with(blockModelGenerators.createColumnWithFacing()));
    }

    private static void createPinkSaltCluster(BlockModelGenerators blockModelGenerators) {
        Variant multivariant = Variant.variant().with(VariantProperties.MODEL, (Object)GModelTemplates.PINK_SALT_CLUSTER.create((Block)GBlocks.PINK_SALT_CLUSTER.get(), TextureMapping.defaultTexture((Block)((Block)GBlocks.PINK_SALT_CLUSTER.get())), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.PINK_SALT_CLUSTER.get()), (Variant)multivariant).with(blockModelGenerators.createColumnWithFacing()));
    }

    private void createChiseledPinkSalt(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> polished, DeferredBlock<Block> block) {
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)((Block)block.get()))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side")).put(GModelTemplates.GTextureSlots.SMOOTH, TextureMapping.getBlockTexture((Block)((Block)polished.get())));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)block.get()), (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)GModelTemplates.CHISELED_ORIENTABLE.create((Block)block.get(), textureMapping, blockModelGenerators.modelOutput))).with(PropertyDispatch.property((Property)BlockStateProperties.ORIENTATION).generate(frontAndTop -> this.applyRotation((FrontAndTop)frontAndTop, Variant.variant()))));
    }

    public final Variant applyRotation(FrontAndTop frontAndTop, Variant variant) {
        switch (frontAndTop) {
            case DOWN_NORTH: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90);
            }
            case DOWN_SOUTH: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180);
            }
            case DOWN_WEST: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270);
            }
            case DOWN_EAST: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90);
            }
            case UP_NORTH: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180);
            }
            case UP_SOUTH: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270);
            }
            case UP_WEST: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90);
            }
            case UP_EAST: {
                return variant.with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270);
            }
            case NORTH_UP: {
                return variant;
            }
            case SOUTH_UP: {
                return variant.with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180);
            }
            case WEST_UP: {
                return variant.with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270);
            }
            case EAST_UP: {
                return variant.with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90);
            }
        }
        throw new UnsupportedOperationException("Rotation " + String.valueOf(frontAndTop) + " can't be expressed with existing x and y values");
    }

    private static void createChandelier(BlockModelGenerators blockModelGenerators, Block block) {
        TextureMapping base = new TextureMapping().put(GModelTemplates.GTextureSlots.BASE, Galosphere.id("block/chandelier_base")).put(GModelTemplates.GTextureSlots.BASE_SIDE, Galosphere.id("block/chandelier_base_side")).put(GModelTemplates.GTextureSlots.CHAIN, Galosphere.id("block/chandelier_chain")).put(GModelTemplates.GTextureSlots.FIRE, TextureMapping.getBlockTexture((Block)block, (String)"_fire")).put(TextureSlot.PARTICLE, Galosphere.id("block/chandelier_base_side"));
        ResourceLocation chandelier = GModelTemplates.CHANDELIER.create(block, base, blockModelGenerators.modelOutput);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)chandelier));
    }

    private static void createPalladiumLattice(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> block) {
        Block lattice = (Block)block.get();
        ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Block)lattice, (String)"_post_ends");
        ResourceLocation resourcelocation1 = ModelLocationUtils.getModelLocation((Block)lattice, (String)"_post");
        ResourceLocation resourcelocation2 = ModelLocationUtils.getModelLocation((Block)lattice, (String)"_cap");
        ResourceLocation resourcelocation3 = ModelLocationUtils.getModelLocation((Block)lattice, (String)"_cap_alt");
        ResourceLocation resourcelocation4 = ModelLocationUtils.getModelLocation((Block)lattice, (String)"_side");
        ResourceLocation resourcelocation5 = ModelLocationUtils.getModelLocation((Block)lattice, (String)"_side_alt");
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)lattice).with(Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation1)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation2)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation2).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation3)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)).term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation3).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation4)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation4).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation5)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation5).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)));
        blockModelGenerators.registerSimpleFlatItemModel(lattice);
    }

    private static void createFilledComposter(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> composter) {
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)composter.get())).with(Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)Blocks.COMPOSTER))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(1)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents1"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(2)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents2"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(3)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents3"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(4)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents4"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(5)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents5"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(6)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents6"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(7)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents7"))).with((Condition)Condition.condition().term((Property)BlockStateProperties.LEVEL_COMPOSTER, (Comparable)Integer.valueOf(8)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)((Block)composter.get()), (String)"_contents_ready"))));
    }

    private void createLightStand(BlockModelGenerators blockModelGenerators, DeferredBlock<Block> lightStand) {
        blockModelGenerators.registerSimpleFlatItemModel((Block)lightStand.get(), "_top_lit");
        if (this.lightStandBottom == null) {
            this.lightStandBottom = Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.CROSS.create(Galosphere.id("block/light_stand_bottom"), new TextureMapping().put(TextureSlot.CROSS, Galosphere.id("block/light_stand_bottom")), blockModelGenerators.modelOutput));
        }
        if (this.lightStandTop == null) {
            this.lightStandTop = Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.CROSS.create(Galosphere.id("block/light_stand_top"), new TextureMapping().put(TextureSlot.CROSS, Galosphere.id("block/light_stand_top")), blockModelGenerators.modelOutput));
        }
        Variant litTopVariant = Variant.variant().with(VariantProperties.MODEL, (Object)blockModelGenerators.createSuffixedVariant((Block)lightStand.get(), "_top_lit", ModelTemplates.CROSS, TextureMapping::cross));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)lightStand.get())).with(PropertyDispatch.properties((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Property)BlockStateProperties.LIT).generate((half, bool) -> {
            if (half == DoubleBlockHalf.LOWER) {
                return this.lightStandBottom;
            }
            return bool != false ? litTopVariant : this.lightStandTop;
        })));
    }

    private static void createLichenVines(BlockModelGenerators blockModelGenerators) {
        PropertyDispatch.C1 select = PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant()).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)GBlocks.LICHEN_VINES.get()), (ResourceLocation)Galosphere.id("block/lichen_vines")).with((PropertyDispatch)select));
    }

    private static void createLichenShelf(BlockModelGenerators blockModelGenerators) {
        TexturedModel texturedmodel = TexturedModel.CORAL_FAN.get((Block)GBlocks.LICHEN_SHELF.get());
        Variant multivariant1 = Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.CORAL_WALL_FAN.create((Block)GBlocks.LICHEN_SHELF.get(), texturedmodel.getMapping(), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.LICHEN_SHELF.get()), (Variant)multivariant1).with(BlockModelGenerators.createHorizontalFacingDispatch()));
        blockModelGenerators.registerSimpleFlatItemModel((Block)GBlocks.LICHEN_SHELF.get());
    }

    private static void createBurrowAnchor(BlockModelGenerators blockModelGenerators) {
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_side")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom"));
        ResourceLocation resourceLocation = GModelTemplates.BURROW_ANCHOR.create((Block)GBlocks.BURROW_ANCHOR.get(), textureMapping, blockModelGenerators.modelOutput);
        TextureMapping textureMapping1 = new TextureMapping().put(TextureSlot.TOP, BuiltInRegistries.BLOCK.getKey((Object)((Block)GBlocks.BURROW_ANCHOR.get())).withPath(string -> "block/powered_" + string)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_side")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)GBlocks.BURROW_ANCHOR.get()), (String)"_bottom"));
        ResourceLocation resourceLocation1 = GModelTemplates.BURROW_ANCHOR.create(Galosphere.id("block/powered_burrow_anchor"), textureMapping1, blockModelGenerators.modelOutput);
        Variant multiVariant = Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation);
        Variant multiVariant1 = Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation1);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.BURROW_ANCHOR.get())).with(PropertyDispatch.property((Property)BlockStateProperties.POWERED).generate(bool -> bool != false ? multiVariant1 : multiVariant)));
    }

    private void generateItemModels(ItemModelGenerators itemModelGenerators) {
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.ALLURITE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.LUMIERE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
        this.createItemBlockDir(itemModelGenerators, (Block)GBlocks.LICHEN_VINES.get());
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.PINK_SALT_STRAW);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.CHANDELIER);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.SOUL_CHANDELIER);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.ALLURITE_SHARD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.LUMIERE_SHARD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PINK_SALT_SHARD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.RAW_PALLADIUM);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PALLADIUM_INGOT);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PALLADIUM_NUGGET);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PALLADIUM_BOMB);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PRESERVED_TEMPLATE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.GLOW_FLARE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SPECTRE_FLARE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.PRESERVED_FLESH);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.GOLDEN_LICHEN_CORDYCEPS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.ICON_ITEM);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.GILDED_BEADS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.CURED_MEMBRANE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_HELMET);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_CHESTPLATE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_LEGGINGS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_BOOTS);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.STERLING_HORSE_ARMOR);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SALTED_JERKY);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.BOTTLE_OF_SPECTRE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GBlocks.PINK_SALT_CLUSTER);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SHRINE_KEY);
        this.createHandheldItem(itemModelGenerators, (ItemLike)GItems.ECHO_BELL);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.THIRST_POTTERY_SHERD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.WAVE_POTTERY_SHERD);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.OPAL_FLAKES);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.FAITH_ARMOR_TRIM_SMITHING_TEMPLATE);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.OPAL);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.WEAPON_RACK);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.SILVERFISH);
        this.createGeneratedItem(itemModelGenerators, (ItemLike)GItems.BROKEN_ECHO_BELL);
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)Items.SPYGLASS));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)Items.SPYGLASS, (String)"_in_hand"));
        itemModelGenerators.itemModelOutput.accept((Item)GItems.SPECTRE_BOUND_SPYGLASS.get(), ItemModelGenerators.createFlatModelDispatch((ItemModel.Unbaked)unbaked, (ItemModel.Unbaked)unbaked2));
        this.generateMiningPouch(itemModelGenerators);
        this.generateRopeDart(itemModelGenerators);
        this.generateSaltboundTablet(itemModelGenerators);
        this.generateMonstrometer(itemModelGenerators);
        itemModelGenerators.generateSpawnEgg((Item)GItems.SPARKLE_SPAWN_EGG.get(), 15791604, 2422488);
        itemModelGenerators.generateSpawnEgg((Item)GItems.SPECTRE_SPAWN_EGG.get(), 0xFFF3DD, 10276278);
        itemModelGenerators.generateSpawnEgg((Item)GItems.SPECTERPILLAR_SPAWN_EGG.get(), 0xFFF3DD, 16240507);
        itemModelGenerators.generateSpawnEgg((Item)GItems.BERSERKER_SPAWN_EGG.get(), 15568753, 6057047);
        itemModelGenerators.generateSpawnEgg((Item)GItems.PRESERVED_SPAWN_EGG.get(), 15703431, 7246179);
        itemModelGenerators.generateSpawnEgg((Item)GItems.MOLE_SPAWN_EGG.get(), 5394255, 12762035);
    }

    private void generateMonstrometer(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.MONSTROMETER.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_fueled", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, (ConditionalItemModelProperty)new MonstrometerFueled(), unbaked2, unbaked);
    }

    private void generateSaltboundTablet(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.SALTBOUND_TABLET.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_using", ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked3 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_cooldown", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), unbaked2, ItemModelUtils.conditional((ConditionalItemModelProperty)new Cooldown(), (ItemModel.Unbaked)unbaked3, (ItemModel.Unbaked)unbaked));
    }

    private void generateRopeDart(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.ROPE_DART.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_using", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, ItemModelUtils.isUsingItem(), unbaked2, unbaked);
    }

    private void generateMiningPouch(ItemModelGenerators itemModelGenerators) {
        Item item = (Item)GItems.MINING_POUCH.get();
        ItemModel.Unbaked unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked unbaked2 = ItemModelUtils.plainModel((ResourceLocation)itemModelGenerators.createFlatItemModel(item, "_filled", ModelTemplates.FLAT_ITEM));
        itemModelGenerators.generateBooleanDispatch(item, (ConditionalItemModelProperty)new MiningPouchFilled(), unbaked2, unbaked);
    }

    private void createItemBlockDir(ItemModelGenerators itemModelGenerators, Block block) {
        itemModelGenerators.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModelWithBlockTexture(itemModelGenerators, block.asItem(), block)));
    }

    public ResourceLocation createFlatItemModelWithBlockTexture(ItemModelGenerators itemModelGenerators, Item item, Block block) {
        return ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Block)block), itemModelGenerators.modelOutput);
    }

    private void createGeneratedItem(ItemModelGenerators itemModelGenerators, ItemLike item) {
        itemModelGenerators.generateFlatItem(item.asItem(), ModelTemplates.FLAT_ITEM);
    }

    private void createHandheldItem(ItemModelGenerators itemModelGenerators, ItemLike item) {
        itemModelGenerators.generateFlatItem(item.asItem(), ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    private static void createStrandedMembrane(BlockModelGenerators blockModelGenerators) {
        Block block = (Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get();
        ResourceLocation bottom = TextureMapping.getBlockTexture((Block)block, (String)"_bottom");
        ResourceLocation top = TextureMapping.getBlockTexture((Block)block, (String)"_top");
        ResourceLocation side = TextureMapping.getBlockTexture((Block)block, (String)"_side");
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.BOTTOM, bottom).put(TextureSlot.TOP, top).put(TextureSlot.SIDE, side);
        Variant multiVariant = Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.CUBE_BOTTOM_TOP.create(block, textureMapping, blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)multiVariant).with(blockModelGenerators.createColumnWithFacing()));
    }

    private static void createCombustionTable(BlockModelGenerators blockModelGenerators) {
        ResourceLocation bottom = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_bottom");
        ResourceLocation top = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_top");
        ResourceLocation side0 = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_side0");
        ResourceLocation side1 = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_side1");
        ResourceLocation side2 = TextureMapping.getBlockTexture((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (String)"_side2");
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.DOWN, bottom).put(TextureSlot.UP, top).put(TextureSlot.EAST, side1).put(TextureSlot.NORTH, side2).put(TextureSlot.SOUTH, side2).put(TextureSlot.WEST, side0).put(TextureSlot.PARTICLE, side2);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)GBlocks.COMBUSTION_TABLE.get()), (ResourceLocation)ModelTemplates.CUBE.create((Block)GBlocks.COMBUSTION_TABLE.get(), texturemapping, blockModelGenerators.modelOutput)));
    }

    private static void createPinkSaltStraw(BlockModelGenerators blockModelGenerators) {
        PropertyDispatch.C2 c2 = PropertyDispatch.properties((Property)BlockStateProperties.VERTICAL_DIRECTION, PinkSaltStrawBlock.STRAW_SHAPE);
        for (PinkSaltStrawBlock.StrawShape strawShape : PinkSaltStrawBlock.StrawShape.values()) {
            c2.select((Comparable)Direction.UP, (Comparable)((Object)strawShape), GModelProvider.createPinkSaltStrawVariant(Direction.UP, strawShape, blockModelGenerators));
        }
        for (PinkSaltStrawBlock.StrawShape strawShape : PinkSaltStrawBlock.StrawShape.values()) {
            c2.select((Comparable)Direction.DOWN, (Comparable)((Object)strawShape), GModelProvider.createPinkSaltStrawVariant(Direction.DOWN, strawShape, blockModelGenerators));
        }
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.PINK_SALT_STRAW.get())).with((PropertyDispatch)c2));
    }

    private static Variant createPinkSaltStrawVariant(Direction direction, PinkSaltStrawBlock.StrawShape shape, BlockModelGenerators blockModelGenerators) {
        String s = "_" + direction.getSerializedName() + "_" + shape.getSerializedName();
        TextureMapping textureMapping = TextureMapping.cross((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)GBlocks.PINK_SALT_STRAW.get()), (String)s));
        return Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.POINTED_DRIPSTONE.createWithSuffix((Block)GBlocks.PINK_SALT_STRAW.get(), s, textureMapping, blockModelGenerators.modelOutput));
    }

    private static void createShadowFrame(BlockModelGenerators blockModelGenerators) {
        ResourceLocation multivariant = TexturedModel.CUBE.create((Block)GBlocks.SHADOW_FRAME.get(), blockModelGenerators.modelOutput);
        ResourceLocation multivariant1 = blockModelGenerators.createSuffixedVariant((Block)GBlocks.SHADOW_FRAME.get(), "_filled", ModelTemplates.CUBE_ALL, TextureMapping::cube);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.SHADOW_FRAME.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.POWERED, (ResourceLocation)multivariant1, (ResourceLocation)multivariant)));
    }

    private static void createLichenMoss(BlockModelGenerators blockModelGenerators) {
        ResourceLocation multivariant = TexturedModel.CUBE.create((Block)GBlocks.LICHEN_MOSS.get(), blockModelGenerators.modelOutput);
        ResourceLocation multivariant1 = blockModelGenerators.createSuffixedVariant((Block)GBlocks.LICHEN_MOSS.get(), "_lit", ModelTemplates.CUBE_ALL, TextureMapping::cube);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)GBlocks.LICHEN_MOSS.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (ResourceLocation)multivariant1, (ResourceLocation)multivariant)));
    }

    private void createPollinatedCluster(BlockModelGenerators blockModelGenerators, @NotNull Block block) {
        ResourceLocation id = ModelTemplates.CROSS.create(block, TextureMapping.cross((Block)block), blockModelGenerators.modelOutput);
        Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)id);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)variant).with(blockModelGenerators.createColumnWithFacing()));
    }
}

