/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.compat.init.ForgeItemTags;
import net.orcinus.galosphere.datagen.recipes.PreservedRecipeBuilder;
import net.orcinus.galosphere.init.GBlockFamilies;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;

public class GRecipeProvider
extends RecipeProvider {
    private static final ImmutableList<ItemLike> PALLADIUM_SMELTABLES = ImmutableList.of((Object)((Block)GBlocks.PALLADIUM_ORE.get()).asItem(), (Object)((Block)GBlocks.DEEPSLATE_PALLADIUM_ORE.get()).asItem(), (Object)((ItemLike)GItems.RAW_PALLADIUM.get()));

    protected GRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        GBlockFamilies.getAllFamilies().forEach(blockFamily -> this.generateRecipes((BlockFamily)blockFamily, FeatureFlags.VANILLA_SET));
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.COAL).requires((ItemLike)GItems.PINK_SALT_SHARD.get()).unlockedBy("has_pink_salt_shard", this.has((ItemLike)GItems.PINK_SALT_SHARD.get())).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GBlocks.PINK_SALT.get()).define(Character.valueOf('#'), (ItemLike)((Block)GBlocks.PINK_SALT_STRAW.get()).asItem()).pattern("##").pattern("##").unlockedBy("has_pink_salt_straw", this.has((ItemLike)GBlocks.PINK_SALT_STRAW.get())).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.GILDED_BEADS.get(), 8).define(Character.valueOf('#'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).pattern("GGG").pattern("###").pattern("GGG").unlockedBy("has_gold_ingot", this.has((ItemLike)Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.STRANDED_MEMBRANE_BLOCK.get()).define(Character.valueOf('#'), (ItemLike)GItems.ALLURITE_SHARD.get()).define(Character.valueOf('C'), (ItemLike)GBlocks.CURED_MEMBRANE_BLOCK.get()).pattern(" # ").pattern("#C#").pattern(" # ").unlockedBy("has_cured_membrane_block", this.has((ItemLike)GBlocks.CURED_MEMBRANE_BLOCK.get())).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GBlocks.SHADOW_FRAME.get(), 8).define(Character.valueOf('S'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('#'), (ItemLike)GItems.CURED_MEMBRANE.get()).pattern("S#S").pattern("#S#").pattern("S#S").unlockedBy("has_cured_membrane", this.has((ItemLike)GItems.CURED_MEMBRANE.get())).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)GBlocks.PINK_SALT_LAMP.get()).define(Character.valueOf('#'), (ItemLike)GBlocks.PINK_SALT_CLUSTER.get()).define(Character.valueOf('S'), ForgeItemTags.PALLADIUM_INGOT).pattern("#").pattern("S").unlockedBy("has_pink_salt_cluster", this.has((ItemLike)GBlocks.PINK_SALT_CLUSTER.get())).save(this.output);
        this.shaped(RecipeCategory.FOOD, (ItemLike)GItems.SALTED_JERKY.get()).define(Character.valueOf('S'), (ItemLike)GItems.PINK_SALT_SHARD.get()).define(Character.valueOf('#'), (ItemLike)Items.ROTTEN_FLESH).pattern(" S ").pattern("S#S").pattern(" S ").unlockedBy("has_pink_salt_shard", this.has((ItemLike)GItems.PINK_SALT_SHARD.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)GItems.CURED_MEMBRANE.get()).define(Character.valueOf('S'), (ItemLike)GItems.PINK_SALT_SHARD.get()).define(Character.valueOf('#'), (ItemLike)Items.PHANTOM_MEMBRANE).pattern(" S ").pattern("S#S").pattern(" S ").unlockedBy("has_pink_salt_shard", this.has((ItemLike)GItems.PINK_SALT_SHARD.get())).save(this.output);
        this.twoXtwo((ItemLike)GBlocks.CURED_MEMBRANE_BLOCK.get(), (ItemLike)GItems.CURED_MEMBRANE.get());
        this.twoXtwo((ItemLike)GBlocks.ALLURITE_BLOCK.get(), (Item)GItems.ALLURITE_SHARD.get(), 1);
        this.twoXtwo((ItemLike)GBlocks.LUMIERE_BLOCK.get(), (Item)GItems.LUMIERE_SHARD.get(), 1);
        this.threeXthree((ItemLike)GBlocks.PALLADIUM_BLOCK.get(), (Item)GItems.PALLADIUM_INGOT.get());
        this.threeXthree((ItemLike)GBlocks.RAW_PALLADIUM_BLOCK.get(), (Item)GItems.RAW_PALLADIUM.get());
        this.nineBlockStorageRecipesWithCustomPacking(RecipeCategory.MISC, (ItemLike)GItems.PALLADIUM_NUGGET.get(), RecipeCategory.MISC, (ItemLike)GItems.PALLADIUM_INGOT.get(), "palladium_ingot_from_nuggets", "palladium_ingot");
        this.oreSmelting((List<ItemLike>)PALLADIUM_SMELTABLES, (ItemLike)GItems.PALLADIUM_INGOT.get(), 0.7f, 200, "silver_ingot");
        this.oreBlasting((List<ItemLike>)PALLADIUM_SMELTABLES, (ItemLike)GItems.PALLADIUM_INGOT.get(), 0.7f, 100, "silver_ingot");
        this.shaplessOne((Item)GItems.PALLADIUM_INGOT.get(), ((Block)GBlocks.PALLADIUM_BLOCK.get()).asItem(), 9);
        this.shaplessOne((Item)GItems.RAW_PALLADIUM.get(), ((Block)GBlocks.RAW_PALLADIUM_BLOCK.get()).asItem(), 9);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.PALLADIUM_LATTICE.get(), 16).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).pattern("###").pattern("###").unlockedBy("has_silver_ingot", this.has((ItemLike)GItems.PALLADIUM_INGOT.get())).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)GItems.GLOW_FLARE.get(), 4).define(Character.valueOf('#'), (ItemLike)Items.GLOW_INK_SAC).define(Character.valueOf('S'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('F'), (ItemLike)Items.STICK).pattern(" # ").pattern(" S ").pattern(" F ").unlockedBy("has_glow_ink_sac", this.has((ItemLike)Items.GLOW_INK_SAC)).unlockedBy("has_copper_ingot", this.has(Tags.Items.INGOTS_COPPER)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)GItems.SPECTRE_FLARE.get()).define(Character.valueOf('#'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('S'), (ItemLike)GItems.BOTTLE_OF_SPECTRE.get()).pattern("S").pattern("#").unlockedBy("has_silver_ingot", this.has(ForgeItemTags.PALLADIUM_INGOT)).unlockedBy("has_bottle_of_spectre", this.has((ItemLike)GItems.BOTTLE_OF_SPECTRE.get())).save(this.output);
        this.shaped(RecipeCategory.FOOD, (ItemLike)GItems.GOLDEN_LICHEN_CORDYCEPS.get()).define(Character.valueOf('#'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('@'), (ItemLike)GItems.LICHEN_CORDYCEPS.get()).pattern("###").pattern("#@#").pattern("###").unlockedBy("has_lichen_cordyceps", this.has((ItemLike)GItems.LICHEN_CORDYCEPS.get())).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.CHANDELIER.get()).define(Character.valueOf('#'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('@'), (ItemLike)GItems.BOTTLE_OF_SPECTRE.get()).define(Character.valueOf('C'), Tags.Items.INGOTS_IRON).pattern("@").pattern("C").pattern("#").unlockedBy("has_copper_ingot", this.has(Tags.Items.INGOTS_COPPER)).unlockedBy("has_iron_nugget", this.has(Tags.Items.INGOTS_IRON)).unlockedBy("has_bottle_of_spectre", this.has((ItemLike)GItems.BOTTLE_OF_SPECTRE.get())).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.COMBUSTION_TABLE.get()).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), ForgeItemTags.PALLADIUM_INGOT).pattern("@@").pattern("##").pattern("##").unlockedBy("has_silver_ingot", this.has(ForgeItemTags.PALLADIUM_INGOT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.AMETHYST_LAMP.get()).define(Character.valueOf('R'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_amethyst_shard", this.has((ItemLike)Items.AMETHYST_SHARD)).unlockedBy("has_glowstone", this.has((ItemLike)Blocks.GLOWSTONE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.ALLURITE_LAMP.get()).define(Character.valueOf('R'), (ItemLike)GItems.ALLURITE_SHARD.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_allurite_shard", this.has((ItemLike)GItems.ALLURITE_SHARD.get())).unlockedBy("has_glowstone", this.has((ItemLike)Blocks.GLOWSTONE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)GBlocks.LUMIERE_LAMP.get()).define(Character.valueOf('R'), (ItemLike)GItems.LUMIERE_SHARD.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_lumiere_shard", this.has((ItemLike)GItems.LUMIERE_SHARD.get())).unlockedBy("has_glowstone", this.has((ItemLike)Blocks.GLOWSTONE)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)GItems.PALLADIUM_BOMB.get(), 2).define(Character.valueOf('R'), ForgeItemTags.PALLADIUM_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GUNPOWDER).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_gunpowder", this.has((ItemLike)Items.GUNPOWDER)).save(this.output);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_WALL.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT_WALL.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_PINK_SALT.get(), (ItemLike)GBlocks.PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PINK_SALT_WALL.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.POLISHED_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_ROSE_PINK_SALT.get(), (ItemLike)GBlocks.ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT_WALL.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.POLISHED_ROSE_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ROSE_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.ROSE_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_PASTEL_PINK_SALT.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_SLAB.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT_WALL.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.POLISHED_PASTEL_PINK_SALT.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_STAIRS.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_SLAB.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PASTEL_PINK_SALT_BRICK_WALL.get(), (ItemLike)GBlocks.PASTEL_PINK_SALT_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_AMETHYST.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_SLAB.get(), (ItemLike)Blocks.AMETHYST_BLOCK, 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_STAIRS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_AMETHYST_SLAB.get(), (ItemLike)Blocks.AMETHYST_BLOCK, 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_ALLURITE_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_LUMIERE_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_AMETHYST_SLAB.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_ALLURITE_SLAB.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_LUMIERE_SLAB.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)Blocks.AMETHYST_BLOCK, 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICKS.get(), (ItemLike)Blocks.AMETHYST_BLOCK);
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICKS.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICKS.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.AMETHYST_BRICKS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.ALLURITE_BRICKS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.LUMIERE_BRICKS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get());
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_PANEL.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_PANEL_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_PANEL_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 4);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_BLOCK.get(), 4);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_PANEL_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_PANEL_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 4);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_PANEL.get(), 4);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get(), (ItemLike)GBlocks.PALLADIUM_TILES.get(), 2);
        this.stonecutterResultFromBase((ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get(), (ItemLike)GBlocks.PALLADIUM_TILES.get(), 4);
        PreservedRecipeBuilder.create(Ingredient.of(GItems.PRESERVED_TEMPLATE), Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(GItemTags.PRESERVABLE_ITEMS)), Ingredient.of(GItems.PINK_SALT_SHARD)).unlocks("has_smithing_trim_template", this.has((ItemLike)GItems.PRESERVED_TEMPLATE)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Galosphere.id("preserved_transform_recipe")));
    }

    protected void stonecutterResultFromBase(ItemLike result, ItemLike ingredient) {
        this.stonecutterResultFromBase(result, ingredient, 1);
    }

    protected void stonecutterResultFromBase(ItemLike result, ItemLike ingredient, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).unlockedBy(GRecipeProvider.getHasName(ingredient), this.has(ingredient)).save(this.output, GRecipeProvider.getConversionRecipeName(result, ingredient) + "_stonecutting");
    }

    protected static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return GRecipeProvider.getItemName(result) + "_from_" + GRecipeProvider.getItemName(ingredient);
    }

    private void chiseled(Item slab, Item result) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, 1).define(Character.valueOf('#'), (ItemLike)slab).pattern("#").pattern("#").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)slab).getPath(), this.has((ItemLike)slab)).save(this.output);
    }

    private void shaplessOne(Item result, Item item, int count) {
        this.shapeless(RecipeCategory.MISC, (ItemLike)result, count).requires((ItemLike)item).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), this.has((ItemLike)item)).save(this.output);
    }

    private void twoXtwo(ItemLike result, ItemLike item) {
        this.twoXtwo(result, item.asItem(), 4);
    }

    private void twoXtwo(ItemLike result, Item item, int count) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).define(Character.valueOf('S'), (ItemLike)item).pattern("SS").pattern("SS").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), this.has((ItemLike)item)).save(this.output);
    }

    private void threeXthree(ItemLike result, Item item) {
        this.shaped(RecipeCategory.MISC, result).define(Character.valueOf('S'), (ItemLike)item).pattern("SSS").pattern("SSS").pattern("SSS").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), this.has((ItemLike)item)).save(this.output);
    }

    private void stairsBlock(ItemLike result, Item item) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 4).define(Character.valueOf('#'), (ItemLike)item).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), this.has((ItemLike)item)).save(this.output);
    }

    private void slabBlock(ItemLike result, Item item) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 6).define(Character.valueOf('#'), (ItemLike)item).pattern("###").unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)item).getPath(), this.has((ItemLike)item)).save(this.output);
    }

    protected void oreSmelting(List<ItemLike> items, ItemLike p_176594_, float p_176595_, int p_176596_, String p_176597_) {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, items, p_176594_, p_176595_, p_176596_, p_176597_, "_from_smelting");
    }

    protected void oreBlasting(List<ItemLike> items, ItemLike p_176628_, float p_176629_, int p_176630_, String p_176631_) {
        this.oreCooking(RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, items, p_176628_, p_176629_, p_176630_, p_176631_, "_from_blasting");
    }

    protected <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> itemLike, ItemLike item, float experience, int time, String group, String name) {
        for (ItemLike itemlike : itemLike) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)itemlike), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)experience, (int)time, serializer, factory).group(group).unlockedBy(GRecipeProvider.getHasName(itemlike), this.has(itemlike)).save(this.output, GRecipeProvider.getItemName(item) + name + "_" + GRecipeProvider.getItemName(itemlike));
        }
    }

    protected static String getHasName(ItemLike p_176603_) {
        return "has_" + GRecipeProvider.getItemName(p_176603_);
    }

    protected static String getItemName(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new GRecipeProvider(registries, output);
        }

        public String getName() {
            return "galosphere";
        }
    }
}

