/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.UpdateSpectreBoundPacket;
import org.jetbrains.annotations.Nullable;

public class SpectatorVision
extends AmbientCreature
implements Spectatable {
    private static final EntityDataAccessor<Optional<UUID>> MANIPULATOR = SynchedEntityData.defineId(SpectatorVision.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(SpectatorVision.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SPECTATING_TICKS = SynchedEntityData.defineId(SpectatorVision.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SpectatorVision(Level level) {
        super(GEntityTypes.SPECTATOR_VISION.get(), level);
    }

    public SpectatorVision(EntityType<? extends AmbientCreature> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, (double)0.1f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MANIPULATOR, Optional.empty());
        builder.define(PHASE, (Object)0);
        builder.define(SPECTATING_TICKS, (Object)0);
    }

    public boolean isInvulnerableTo(ServerLevel p_361436_, DamageSource p_345519_) {
        return true;
    }

    public void aiStep() {
        super.aiStep();
        if (this.getManipulatorUUID() == null) {
            this.discard();
        }
        if (!this.level().isClientSide() || this.matchesClientPlayerUUID()) {
            ((Optional)this.entityData.get(MANIPULATOR)).ifPresent(this::spectateTick);
        }
        if (!this.level().isClientSide) {
            int spectatableTime = this.getSpectatableTime();
            if (spectatableTime > 0) {
                this.setSpectatableTime(spectatableTime - 1);
            }
            if (this.getPhase() < 12 && this.tickCount % 5 == 0) {
                this.setPhase(this.getPhase() + 1);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.random.nextInt(5) == 0) {
            int count = UniformInt.of((int)3, (int)6).sample(this.random);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos blockPos = this.blockPosition();
            int range = 3;
            for (int i = 0; i < count; ++i) {
                mutableBlockPos.setWithOffset((Vec3i)blockPos, Mth.nextInt((RandomSource)this.random, (int)(-range), (int)range), Mth.nextInt((RandomSource)this.random, (int)(-range), (int)range), Mth.nextInt((RandomSource)this.random, (int)(-range), (int)range));
                if (this.level().getBlockState((BlockPos)mutableBlockPos).isCollisionShapeFullBlock((BlockGetter)this.level(), (BlockPos)mutableBlockPos)) continue;
                float velX = 0.06f * (float)(blockPos.getX() - mutableBlockPos.getX());
                float velY = 0.06f * (float)(blockPos.getY() - mutableBlockPos.getY());
                float velZ = 0.06f * (float)(blockPos.getZ() - mutableBlockPos.getZ());
                this.level().addParticle((ParticleOptions)GParticleTypes.SPECTATE_ORB.get(), (double)((float)mutableBlockPos.getX() + 0.5f), (double)mutableBlockPos.getY(), (double)((float)mutableBlockPos.getZ() + 0.5f), (double)velX, (double)velY, (double)velZ);
            }
        }
    }

    public HumanoidArm getMainArm() {
        return null;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSpectatableTime(tag.getInt("SpectatingTicks"));
        this.setPhase(tag.getInt("Phase"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("SpectatingTicks", this.getSpectatableTime());
        tag.putInt("Phase", this.getPhase());
    }

    public ItemStack getItemBySlot(EquipmentSlot equipmentSlot) {
        return ItemStack.EMPTY;
    }

    public void travel(Vec3 vec3) {
        if (this.getManipulatorUUID() == null) {
            super.travel(vec3);
        }
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    @Override
    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.entityData.get(MANIPULATOR)).orElse(null);
    }

    @Override
    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.entityData.set(MANIPULATOR, Optional.ofNullable(uuid));
    }

    @Override
    public void spectateTick(UUID uuid) {
        Player player = this.level().getPlayerByUUID(uuid);
        if (player != null) {
            player.xxa = 0.0f;
            player.zza = 0.0f;
            player.setJumping(false);
            this.copyPlayerRotation((LivingEntity)this, player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UpdateSpectreBoundPacket(this.getSpectatableTime() > 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (player.isDiscrete() || this.getSpectatableTime() == 0) {
                this.setManipulatorUUID(null);
                if (this.level().isClientSide) {
                    this.stopUsingSpyglass(player);
                } else {
                    player.setData(GAttachmentTypes.IS_SPECTRE_BOUNDED, (Object)false);
                    player.playNotifySound(GSoundEvents.SPECTRE_MANIPULATE_END.get(), this.getSoundSource(), 1.0f, 1.0f);
                    this.discard();
                }
            }
        }
        if (!this.level().isClientSide() && player == null) {
            this.entityData.set(MANIPULATOR, Optional.empty());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopUsingSpyglass(Player player) {
        Minecraft client = Minecraft.getInstance();
        if (client.player == player) {
            client.setCameraEntity((Entity)player);
        }
    }

    public int getPhase() {
        return (Integer)this.entityData.get(PHASE);
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)phase);
    }

    public static SpectatorVision create(Level world, Vec3 blockPos, ServerPlayer serverPlayer, int ticks) {
        SpectatorVision spectatorVision = new SpectatorVision(world);
        spectatorVision.moveTo(blockPos.x, blockPos.y, blockPos.z);
        spectatorVision.setSpectatableTime(ticks);
        spectatorVision.setManipulatorUUID(serverPlayer.getUUID());
        return spectatorVision;
    }

    public int getSpectatableTime() {
        return (Integer)this.entityData.get(SPECTATING_TICKS);
    }

    public void setSpectatableTime(int time) {
        this.entityData.set(SPECTATING_TICKS, (Object)time);
    }
}

