/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.orcinus.galosphere.entities.ai.SpecterpillarAi;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Specterpillar
extends PathfinderMob {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Specterpillar>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, GSensorTypes.SPECTRE_TEMPTATIONS.get(), GSensorTypes.NEAREST_LICHEN_MOSS.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.IS_PANICKING, GMemoryModuleTypes.CAN_BURY.get(), (Object[])new MemoryModuleType[]{GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()});
    public final AnimationState burrowAnimationState = new AnimationState();
    private int age;

    public Specterpillar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public boolean isPushable() {
        return this.getPose() != Pose.DIGGING && super.isPushable();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (DATA_POSE.equals(entityDataAccessor)) {
            if (this.getPose() == Pose.DIGGING) {
                this.burrowAnimationState.start(this.tickCount);
            } else {
                this.burrowAnimationState.stop();
            }
        }
        super.onSyncedDataUpdated(entityDataAccessor);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    protected Brain.Provider<Specterpillar> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public Brain<Specterpillar> getBrain() {
        return super.getBrain();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return SpecterpillarAi.makeBrain((Brain<Specterpillar>)this.brainProvider().makeBrain(dynamic));
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return GSoundEvents.SPECTERPILLAR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return GSoundEvents.SPECTERPILLAR_DEATH.get();
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("specterpillarBrain");
        this.getBrain().tick(serverLevel, (LivingEntity)this);
        profiler.pop();
        profiler.push("SpecterpillarActivityUpdate");
        SpecterpillarAi.updateActivity(this);
        profiler.pop();
        super.customServerAiStep(serverLevel);
    }

    public void setAge(int i) {
        this.age = i;
    }

    public int getAge() {
        return this.age;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        MemoryModuleType<Boolean> moduleType = GMemoryModuleTypes.CAN_BURY.get();
        if (!this.level().isClientSide && stack.is(GItemTags.SPECTRE_TEMPT_ITEMS) && !this.getBrain().hasMemoryValue(moduleType)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (this.getRandom().nextInt(5) == 0) {
                this.getBrain().setMemory(moduleType, (Object)true);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, interactionHand);
    }

    public void handleEntityEvent(byte b) {
        if (b == 4) {
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
        } else {
            super.handleEntityEvent(b);
        }
    }

    public boolean shouldDropExperience() {
        return false;
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("Age", this.getAge());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setAge(compoundTag.getInt("Age"));
    }

    public static boolean isValidTargetState(Level level, BlockPos blockPos, LivingEntity livingEntity) {
        return level.getBlockState(blockPos).isAir() && level.getBlockState(blockPos.below()).is((Block)GBlocks.LICHEN_MOSS.get());
    }
}

